/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.seasar.framework.aop.javassist.CannotCompileRuntimeException;
import org.seasar.framework.aop.javassist.ClassPoolUtil;
import org.seasar.framework.aop.javassist.NotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class AbstractGenerator {
    public static final String DEFINE_CLASS_METHOD_NAME = "defineClass";
    protected static final ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$org$seasar$framework$aop$javassist$AspectWeaver == null ? (class$org$seasar$framework$aop$javassist$AspectWeaver = AbstractGenerator.class$("org.seasar.framework.aop.javassist.AspectWeaver")) : class$org$seasar$framework$aop$javassist$AspectWeaver).getProtectionDomain();
        }
    });
    protected static Method defineClassMethod;
    protected final ClassPool classPool;
    static /* synthetic */ Class class$org$seasar$framework$aop$javassist$AspectWeaver;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$ProtectionDomain;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Object;

    public static String fromObject(Class type, String expr) {
        if (type.equals(Void.TYPE) || type.equals(class$java$lang$Object == null ? (class$java$lang$Object = AbstractGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            return expr;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Character.TYPE)) {
            Class wrapper = ClassUtil.getWrapperClass(type);
            return "((" + wrapper.getName() + ") " + expr + ")." + type.getName() + "Value()";
        }
        if (type.isPrimitive()) {
            return "((java.lang.Number) " + expr + ")." + type.getName() + "Value()";
        }
        return "(" + ClassUtil.getSimpleClassName(type) + ") " + expr;
    }

    public static String toObject(Class type, String expr) {
        if (type.isPrimitive()) {
            Class wrapper = ClassUtil.getWrapperClass(type);
            return "new " + wrapper.getName() + "(" + expr + ")";
        }
        return expr;
    }

    protected AbstractGenerator(ClassPool classPool) {
        this.classPool = classPool;
    }

    protected CtClass toCtClass(Class clazz) {
        return ClassPoolUtil.toCtClass(this.classPool, clazz);
    }

    protected CtClass toCtClass(String className) {
        return ClassPoolUtil.toCtClass(this.classPool, className);
    }

    protected CtClass[] toCtClassArray(String[] classNames) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classNames);
    }

    protected CtClass[] toCtClassArray(Class[] classes) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classes);
    }

    protected CtClass createCtClass(String name) {
        return ClassPoolUtil.createCtClass(this.classPool, name);
    }

    protected CtClass createCtClass(String name, Class superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass createCtClass(String name, CtClass superClass) {
        return ClassPoolUtil.createCtClass(this.classPool, name, superClass);
    }

    protected CtClass getAndRenameCtClass(Class orgClass, String newName) {
        return this.getAndRenameCtClass(ClassUtil.getSimpleClassName(orgClass), newName);
    }

    protected CtClass getAndRenameCtClass(String orgName, String newName) {
        try {
            return this.classPool.getAndRename(orgName, newName);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    public Class toClass(ClassLoader classLoader, CtClass ctClass) {
        try {
            byte[] bytecode = ctClass.toBytecode();
            return (Class)defineClassMethod.invoke((Object)classLoader, ctClass.getName(), bytecode, new Integer(0), new Integer(bytecode.length), protectionDomain);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AbstractGenerator.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AbstractGenerator.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, e);
        }
    }

    protected void setInterface(CtClass clazz, Class interfaceType) {
        clazz.setInterfaces(new CtClass[]{this.toCtClass(interfaceType)});
    }

    protected void setInterfaces(CtClass clazz, Class[] interfaces) {
        clazz.setInterfaces(this.toCtClassArray(interfaces));
    }

    protected CtConstructor createDefaultConstructor(Class clazz) {
        return this.createDefaultConstructor(this.toCtClass(clazz));
    }

    protected CtConstructor createDefaultConstructor(CtClass clazz) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.defaultConstructor((CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtConstructor createConstructor(CtClass clazz, Constructor constructor) {
        return this.createConstructor(clazz, this.toCtClassArray(constructor.getParameterTypes()), this.toCtClassArray(constructor.getExceptionTypes()));
    }

    protected CtConstructor createConstructor(CtClass clazz, CtClass[] parameterTypes, CtClass[] exceptionTypes) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameterTypes, (CtClass[])exceptionTypes, (CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod getDeclaredMethod(CtClass clazz, String name, CtClass[] argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, String src) {
        try {
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, Method method, String body) {
        return this.createMethod(clazz, method.getModifiers(), method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), body);
    }

    protected CtMethod createMethod(CtClass clazz, int modifier, Class returnType, String methodName, Class[] parameterTypes, Class[] exceptionTypes, String body) {
        try {
            CtMethod ctMethod = CtNewMethod.make((int)(modifier & 0xFFFFFAFF), (CtClass)this.toCtClass(returnType), (String)methodName, (CtClass[])this.toCtClassArray(parameterTypes), (CtClass[])this.toCtClassArray(exceptionTypes), (String)body, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            ctMethod.setBody(body);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void setMethodBody(CtMethod method, String src) {
        try {
            method.setBody(src);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractGenerator.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = AbstractGenerator.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = AbstractGenerator.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain};
                try {
                    Class loader = ClassUtil.forName((class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AbstractGenerator.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName());
                    defineClassMethod = loader.getDeclaredMethod(AbstractGenerator.DEFINE_CLASS_METHOD_NAME, paramTypes);
                    ((AccessibleObject)defineClassMethod).setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodRuntimeException(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AbstractGenerator.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, AbstractGenerator.DEFINE_CLASS_METHOD_NAME, paramTypes, e);
                }
                return null;
            }
        });
    }
}

