/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AbstractPropertyAssembler;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;

public class AutoPropertyAssembler
extends AbstractPropertyAssembler {
    public AutoPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public void assemble(Object component) {
        int i;
        BeanDesc beanDesc = this.getBeanDesc(component);
        ComponentDef cd = this.getComponentDef();
        int size = cd.getPropertyDefSize();
        HashSet<String> names = new HashSet<String>();
        for (i = 0; i < size; ++i) {
            PropertyDef propDef = cd.getPropertyDef(i);
            BindingTypeDef bindingTypeDef = propDef.getBindingTypeDef();
            String propName = propDef.getPropertyName();
            Field field = this.getField(beanDesc, propName);
            PropertyDesc propDesc = this.getPropertyDesc(beanDesc, propName, field);
            bindingTypeDef.bind(cd, propDef, propDesc, field, component);
            names.add(propName);
        }
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
            String propName = propDesc.getPropertyName();
            if (names.contains(propName)) continue;
            Field field = this.getField(beanDesc, propName);
            BindingTypeDefFactory.SHOULD.bind(cd, null, propDesc, field, component);
        }
    }
}

