/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractAnnotationHandler
implements AnnotationHandler {
    protected static final String COMPONENT = "COMPONENT";
    protected static final String NAME = "name";
    protected static final String INSTANCE = "instance";
    protected static final String AUTO_BINDING = "autoBinding";
    protected static final String BINDING_SUFFIX = "_BINDING";
    protected static final String BINDING_TYPE = "bindingType";
    protected static final String VALUE = "value";
    protected static final String ASPECT = "ASPECT";
    protected static final String INTER_TYPE = "INTER_TYPE";
    protected static final String INIT_METHOD = "INIT_METHOD";
    protected static final String DESTROY_METHOD = "DESTROY_METHOD";
    protected static final String INTERCEPTOR = "interceptor";
    protected static final String POINTCUT = "pointcut";

    public ComponentDef createComponentDef(String className, InstanceDef instanceDef) {
        return this.createComponentDef(ClassUtil.forName(className), instanceDef);
    }

    public void appendDI(ComponentDef componentDef) {
        PropertyDef propDef;
        int i;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentDef.getComponentClass());
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod() || (propDef = this.createPropertyDef(beanDesc, pd)) == null) continue;
            componentDef.addPropertyDef(propDef);
        }
        for (i = 0; i < beanDesc.getFieldSize(); ++i) {
            Field field = beanDesc.getField(i);
            if (!this.isFieldInjectionTarget(field) || (propDef = this.createPropertyDef(beanDesc, field)) == null) continue;
            componentDef.addPropertyDef(propDef);
        }
    }

    protected InstanceDef getInstanceDef(String name, InstanceDef defaultInstanceDef) {
        InstanceDef instanceDef = this.getInstanceDef(name);
        if (instanceDef != null) {
            return instanceDef;
        }
        return defaultInstanceDef;
    }

    protected InstanceDef getInstanceDef(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        return InstanceDefFactory.getInstanceDef(name);
    }

    protected AutoBindingDef getAutoBindingDef(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        return AutoBindingDefFactory.getAutoBindingDef(name);
    }

    protected ComponentDef createComponentDef(Class componentClass, String name, InstanceDef instanceDef, AutoBindingDef autoBindingDef) {
        ComponentDefImpl componentDef = new ComponentDefImpl(componentClass);
        if (!StringUtil.isEmpty(name)) {
            componentDef.setComponentName(name);
        }
        if (instanceDef != null) {
            componentDef.setInstanceDef(instanceDef);
        }
        if (autoBindingDef != null) {
            componentDef.setAutoBindingDef(autoBindingDef);
        }
        return componentDef;
    }

    protected PropertyDef createPropertyDef(String propertyName, String expression, String bindingTypeName) {
        PropertyDefImpl propertyDef = new PropertyDefImpl(propertyName);
        if (!StringUtil.isEmpty(bindingTypeName)) {
            BindingTypeDef bindingTypeDef = BindingTypeDefFactory.getBindingTypeDef(bindingTypeName);
            propertyDef.setBindingTypeDef(bindingTypeDef);
        }
        if (!StringUtil.isEmpty(expression)) {
            propertyDef.setExpression(new OgnlExpression(expression));
        }
        return propertyDef;
    }

    protected boolean isInitMethodRegisterable(ComponentDef cd, String methodName) {
        if (StringUtil.isEmpty(methodName)) {
            return false;
        }
        for (int i = 0; i < cd.getInitMethodDefSize(); ++i) {
            InitMethodDef other = cd.getInitMethodDef(i);
            if (!methodName.equals(other.getMethodName()) || other.getArgDefSize() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isDestroyMethodRegisterable(ComponentDef cd, String methodName) {
        if (StringUtil.isEmpty(methodName)) {
            return false;
        }
        for (int i = 0; i < cd.getDestroyMethodDefSize(); ++i) {
            DestroyMethodDef other = cd.getDestroyMethodDef(i);
            if (!methodName.equals(other.getMethodName()) || other.getArgDefSize() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isFieldInjectionTarget(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    public abstract /* synthetic */ PropertyDef createPropertyDef(BeanDesc var1, Field var2);

    public abstract /* synthetic */ PropertyDef createPropertyDef(BeanDesc var1, PropertyDesc var2);

    public abstract /* synthetic */ void appendDestroyMethod(ComponentDef var1);

    public abstract /* synthetic */ void appendInitMethod(ComponentDef var1);

    public abstract /* synthetic */ void appendInterType(ComponentDef var1);

    public abstract /* synthetic */ void appendAspect(ComponentDef var1);

    public abstract /* synthetic */ ComponentDef createComponentDef(Class var1, InstanceDef var2);
}

