/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.hotswap;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.seasar.framework.hotswap.Hotswap;
import org.seasar.framework.hotswap.HotswapTargetFactory;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.MethodUtil;

public class HotswapProxy
extends Hotswap
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = 0L;
    private transient HotswapTargetFactory hotswapTargetFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public HotswapProxy() {
    }

    protected HotswapProxy(Class targetClass, HotswapTargetFactory hotswapTargetFactory) {
        super(targetClass);
        this.hotswapTargetFactory = hotswapTargetFactory;
    }

    public static Object create(Class targetClass, HotswapTargetFactory hotswapTargetFactory) {
        return HotswapProxy.create(targetClass, hotswapTargetFactory, Thread.currentThread().getContextClassLoader());
    }

    public static Object create(Class targetClass, HotswapTargetFactory hotswapTargetFactory, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, HotswapProxy.getInterfaces(targetClass), (InvocationHandler)new HotswapProxy(targetClass, hotswapTargetFactory));
    }

    static Class[] getInterfaces(Class targetClass) {
        Object[] intfs = targetClass.getInterfaces();
        if (targetClass.isInterface()) {
            Class[] intfs2 = new Class[intfs.length + 1];
            intfs2[0] = targetClass;
            System.arraycopy(intfs, 0, intfs2, 1, intfs.length);
            return intfs2;
        }
        if (!targetClass.equals(class$java$lang$Object == null ? (class$java$lang$Object = HotswapProxy.class$("java.lang.Object")) : class$java$lang$Object)) {
            intfs = (Class[])ArrayUtil.add(intfs, HotswapProxy.getInterfaces(targetClass.getSuperclass()));
        }
        return intfs;
    }

    public static HotswapProxy getProxy(Object o) {
        InvocationHandler ih;
        if (Proxy.isProxyClass(o.getClass()) && (ih = Proxy.getInvocationHandler(o)) instanceof HotswapProxy) {
            return (HotswapProxy)ih;
        }
        return null;
    }

    public HotswapTargetFactory getHotswapTargetFactory() {
        return this.hotswapTargetFactory;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object target = this.hotswapTargetFactory.updateTarget();
        if (MethodUtil.isEqualsMethod(method)) {
            return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (MethodUtil.isHashCodeMethod(method)) {
            return new Integer(target.hashCode());
        }
        if (MethodUtil.isToStringMethod(method)) {
            return target.toString();
        }
        return method.invoke(target, args);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (Proxy.isProxyClass(o.getClass())) {
            o = Proxy.getInvocationHandler(o);
        }
        return this == o;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

