/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.helloworld;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.ActionRequestUtil;
import org.seasar.portlet.util.ActionResponseUtil;
import org.seasar.portlet.util.PortletConfigUtil;
import org.seasar.portlet.util.PortletPreferencesUtil;
import org.seasar.portlet.util.PortletRequestUtil;
import org.seasar.portlet.util.PortletResourceBundleUtil;
import org.seasar.portlet.util.PortletResponseUtil;
import org.seasar.portlet.util.RenderRequestUtil;
import org.seasar.portlet.util.RenderResponseUtil;

import java.io.IOException;
import java.util.Locale;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * HelloWorldPortlet is a portlet to say "Hello!"
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class HelloWorldPortlet extends GenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HelloWorldPortlet.class);

    public static final String YOUR_NAME_KEY = "yourName";

    public static final String COUNT_KEY = "count";

    public static final String PROCESS_ACTION_TRACELOG_KEY = "processActionTraceLog";

    public static final String RENDER_TRACELOG_KEY = "renderTraceLog";

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init() - HelloWorldPortlet: init()");
        }
        super.init(config);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        response.setContentType("text/html");

        if (log.isDebugEnabled())
        {
            log.debug("doView() - HelloWorldPortlet: doView()");
        }
        PortletContext context = getPortletContext();

        String yourName = request.getParameter(YOUR_NAME_KEY);
        if (log.isDebugEnabled())
        {
            log.debug("doView() - yourName=" + yourName);
        }
        if (yourName == null)
        {
            yourName = "";
        }
        request.setAttribute(YOUR_NAME_KEY, yourName);

        String processActionTraceLog = request
                .getParameter(PROCESS_ACTION_TRACELOG_KEY);
        if (processActionTraceLog == null)
        {
            processActionTraceLog = "";
        }
        request.setAttribute(RENDER_TRACELOG_KEY, processActionTraceLog
                + "<b>doView(RenderRequest, RenderResponse)</b><br/>"
                + getS2PortletUtilTraceLog());

        PortletRequestDispatcher rd = context
                .getRequestDispatcher("/WEB-INF/view/helloworld.jsp");
        rd.include(request, response);
    }

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("processAction() - HelloWorldPortlet: processAction()");
        }
        PortletSession session = request.getPortletSession();
        String yourName = request.getParameter(YOUR_NAME_KEY);

        if (yourName != null)
        {
            Integer count = (Integer) session.getAttribute(COUNT_KEY);
            if (count != null)
            {
                count = new Integer(count.intValue() + 1);
            }
            else
            {
                count = new Integer(1);
            }
            if (log.isDebugEnabled())
            {
                log.debug("processAction() - HelloWorldPortlet: yourName = "
                        + yourName + ", count = " + count);
            }

            session.setAttribute(COUNT_KEY, count);
            response.setRenderParameter(YOUR_NAME_KEY, yourName);
        }

        response.setRenderParameter(PROCESS_ACTION_TRACELOG_KEY,
                "<b>processAction(ActionRequest, ActionResponse)</b><br/>"
                        + getS2PortletUtilTraceLog());

        return;
    }

    protected String getS2PortletUtilTraceLog()
    {
        StringBuffer buf = new StringBuffer();

        buf.append("ActionRequestUtil: ");
        buf.append(ActionRequestUtil.getActionRequest());
        buf.append("<br/>");

        buf.append("ActionResponseUtil: ");
        buf.append(ActionResponseUtil.getActionResponse());
        buf.append("<br/>");

        buf.append("PortletConfigUtil: ");
        buf.append(PortletConfigUtil.getPortletConfig());
        buf.append("<br/>");

        buf.append("PortletPreferencesUtil: ");
        buf.append(PortletPreferencesUtil.getPortletPreferences());
        buf.append("<br/>");

        buf.append("PortletRequestUtil: ");
        buf.append(PortletRequestUtil.getPortletRequest());
        buf.append("<br/>");

        buf.append("PortletResponseUtil: ");
        buf.append(PortletResponseUtil.getPortletResponse());
        buf.append("<br/>");

        buf.append("PortletResourceBundleUtil: ");
        buf.append(PortletResourceBundleUtil.getBundle(Locale.ENGLISH));
        buf.append("<br/>");

        buf.append("RenderRequestUtil: ");
        buf.append(RenderRequestUtil.getRenderRequest());
        buf.append("<br/>");

        buf.append("RenderResponseUtil: ");
        buf.append(RenderResponseUtil.getRenderResponse());
        buf.append("<br/>");

        return buf.toString();
    }

}
