<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<%@ taglib uri="http://www.jenia.org/jsf/chart" prefix="jd"%>

<f:view>
	<f:loadBundle
		basename="jp.sf.pal.charttest.resources.ChartTestResources" var="msgs" />

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="1">

			<jd:pieChart3d pieDataSet="#{chartTestSession.dataset}"
				transparency="#{chartTestSession.transparency}"
				color="#{chartTestSession.color}"
				chartTitle="#{chartTestSession.chartTitle}"
				width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				title="#{chartTestSession.title}"
				fileExt="#{chartTestSession.fileType}"
				rendered="#{chartTestSession.pieChart}" />

			<jd:pieChart3d pieDataSet="#{chartTestSession.dataset}" crush="true"
				transparency="#{chartTestSession.transparency}"
				color="#{chartTestSession.color}"
				chartTitle="#{chartTestSession.chartTitle}"
				width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				title="#{chartTestSession.title}"
				fileExt="#{chartTestSession.fileType}"
				rendered="#{chartTestSession.pieChart2D}" />

			<jd:barChart3d dataset="#{chartTestSession.barDataset}"
				width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				fileExt="#{chartTestSession.fileType}"
				chartTitle="#{chartTestSession.chartTitle}" includeLegend="true"
				axisXLabel="#{chartTestSession.axisXLabel}"
				axisYLabel="#{chartTestSession.axisYLabel}"
				formatter="#{chartTestSession.formatter}" type="Line"
				rendered="#{chartTestSession.lineChart}" />

			<jd:barChart3d dataset="#{chartTestSession.barDataset}"
				width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				fileExt="#{chartTestSession.fileType}"
				chartTitle="#{chartTestSession.chartTitle}" includeLegend="true"
				axisXLabel="#{chartTestSession.axisXLabel}"
				axisYLabel="#{chartTestSession.axisYLabel}"
				formatter="#{chartTestSession.formatter}" type="StackedBar"
				rendered="#{chartTestSession.stackBarChart}" />

			<jd:barChart3d dataset="#{chartTestSession.barDataset}"
				labelXOrientation="vertical" tickUnit="5"
				paint="#{chartTestSession.paint}" width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				fileExt="#{chartTestSession.fileType}"
				chartTitle="#{chartTestSession.chartTitle}" includeLegend="true"
				axisXLabel="#{chartTestSession.axisXLabel}"
				axisYLabel="#{chartTestSession.axisYLabel}"
				formatter="#{chartTestSession.formatter}" type="Bar"
				rendered="#{chartTestSession.barChart}" />

			<jd:barChart3d dataset="#{chartTestSession.barDataset}"
				labelXOrientation="vertical" tickUnit="5"
				paint="#{chartTestSession.paint}" width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				fileExt="#{chartTestSession.fileType}"
				chartTitle="#{chartTestSession.chartTitle}" includeLegend="true"
				axisXLabel="#{chartTestSession.axisXLabel}"
				axisYLabel="#{chartTestSession.axisYLabel}"
				formatter="#{chartTestSession.formatter}" type="BarChart2D"
				rendered="#{chartTestSession.barChart2D}" />

			<jd:barChart3d dataset="#{chartTestSession.barDataset}"
				width="#{chartTestSession.width}"
				height="#{chartTestSession.height}"
				fileExt="#{chartTestSession.fileType}"
				chartTitle="#{chartTestSession.chartTitle}" includeLegend="true"
				axisXLabel="#{chartTestSession.axisXLabel}"
				axisYLabel="#{chartTestSession.axisYLabel}"
				formatter="#{chartTestSession.formatter}" type="Area"
				transparency="#{chartTestSession.transparency}" plotColor="#cacaca"
				rendered="#{chartTestSession.areaChart}" />


			<f:facet name="footer">
				<h:commandLink action="NAVI_TO_INPUTVALUE"
					value="#{msgs['displaychart.Back']}"
					styleClass="portlet-form-button" />
			</f:facet>

		</h:panelGrid>

	</h:form>

</f:view>
