/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.myfaces.portlet.wrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.sf.pal.myfaces.portlet.fileupload.PortletDiskFileUpload;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartRequestWrapper
extends org.apache.myfaces.component.html.util.MultipartRequestWrapper
implements ActionRequest {
    private static Log log = LogFactory.getLog((Class)(class$jp$sf$pal$myfaces$portlet$wrapper$MultipartRequestWrapper == null ? (class$jp$sf$pal$myfaces$portlet$wrapper$MultipartRequestWrapper = MultipartRequestWrapper.class$("jp.sf.pal.myfaces.portlet.wrapper.MultipartRequestWrapper")) : class$jp$sf$pal$myfaces$portlet$wrapper$MultipartRequestWrapper));
    ActionRequest request = null;
    HashMap parametersMap = null;
    PortletDiskFileUpload fileUpload = null;
    HashMap fileItems = null;
    int maxSize;
    int thresholdSize;
    String repositoryPath;
    static /* synthetic */ Class class$jp$sf$pal$myfaces$portlet$wrapper$MultipartRequestWrapper;

    public MultipartRequestWrapper(ActionRequest request, int maxSize, int thresholdSize, String repositoryPath) {
        super((HttpServletRequest)request, maxSize, thresholdSize, repositoryPath);
        this.request = request;
        this.maxSize = maxSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
    }

    private void parseRequest() {
        this.fileUpload = new PortletDiskFileUpload();
        this.fileUpload.setFileItemFactory((FileItemFactory)new DefaultFileItemFactory());
        this.fileUpload.setSizeMax(this.maxSize);
        this.fileUpload.setSizeThreshold(this.thresholdSize);
        if (this.repositoryPath != null && this.repositoryPath.trim().length() > 0) {
            this.fileUpload.setRepositoryPath(this.repositoryPath);
        }
        String charset = this.request.getCharacterEncoding();
        this.fileUpload.setHeaderEncoding(charset);
        List requestParameters = null;
        try {
            requestParameters = this.fileUpload.parseRequest(this.request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)"user tried to upload a file that exceeded file-size limitations.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadException fue) {
            log.error((Object)"Exception while uploading file.", (Throwable)fue);
            requestParameters = Collections.EMPTY_LIST;
        }
        this.parametersMap = new HashMap(requestParameters.size());
        this.fileItems = new HashMap();
        Iterator iter = requestParameters.iterator();
        while (iter.hasNext()) {
            FileItem fileItem = (FileItem)iter.next();
            if (fileItem.isFormField()) {
                String name = fileItem.getFieldName();
                String value = null;
                if (charset == null) {
                    value = fileItem.getString();
                } else {
                    try {
                        value = new String(fileItem.get(), charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        value = fileItem.getString();
                    }
                }
                this.addTextParameter(name, value);
                continue;
            }
            if (fileItem.getName() == null) continue;
            this.fileItems.put(fileItem.getFieldName(), fileItem);
        }
        Iterator it = this.request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String[] valuesArray = (String[])entry.getValue();
            for (int i = 0; i < valuesArray.length; ++i) {
                this.addTextParameter((String)entry.getKey(), valuesArray[i]);
            }
        }
    }

    private void addTextParameter(String name, String value) {
        if (!this.parametersMap.containsKey(name)) {
            String[] valuesArray = new String[]{value};
            this.parametersMap.put(name, valuesArray);
        } else {
            String[] storedValues = (String[])this.parametersMap.get(name);
            int lengthSrc = storedValues.length;
            String[] valuesArray = new String[lengthSrc + 1];
            System.arraycopy(storedValues, 0, valuesArray, 0, lengthSrc);
            valuesArray[lengthSrc] = value;
            this.parametersMap.put(name, valuesArray);
        }
    }

    public Enumeration getParameterNames() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parametersMap.keySet());
    }

    public String getParameter(String name) {
        String[] values;
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        if ((values = (String[])this.parametersMap.get(name)) == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return (String[])this.parametersMap.get(name);
    }

    public Map getParameterMap() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return this.parametersMap;
    }

    public FileItem getFileItem(String fieldName) {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        return this.fileItems;
    }

    public Object getAttribute(String arg0) {
        return this.request.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public PortalContext getPortalContext() {
        return this.request.getPortalContext();
    }

    public PortletMode getPortletMode() {
        return this.request.getPortletMode();
    }

    public PortletSession getPortletSession() {
        return this.request.getPortletSession();
    }

    public PortletSession getPortletSession(boolean arg0) {
        return this.request.getPortletSession(arg0);
    }

    public PortletPreferences getPreferences() {
        return this.request.getPreferences();
    }

    public Enumeration getProperties(String arg0) {
        return this.request.getProperties(arg0);
    }

    public String getProperty(String arg0) {
        return this.request.getProperty(arg0);
    }

    public Enumeration getPropertyNames() {
        return this.request.getPropertyNames();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getResponseContentType() {
        return this.request.getResponseContentType();
    }

    public Enumeration getResponseContentTypes() {
        return this.request.getResponseContentTypes();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public WindowState getWindowState() {
        return this.request.getWindowState();
    }

    public boolean isPortletModeAllowed(PortletMode arg0) {
        return this.request.isPortletModeAllowed(arg0);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String arg0) {
        return this.request.isUserInRole(arg0);
    }

    public boolean isWindowStateAllowed(WindowState arg0) {
        return this.request.isWindowStateAllowed(arg0);
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.request.setAttribute(arg0, arg1);
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public InputStream getPortletInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        return this.request.getReader();
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(arg0);
    }

    private ServletRequest getServletRequest() {
        return (ServletRequest)this.request;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

