/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataSetConstants;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class XlsReader
implements DataReader,
DataSetConstants {
    private DataSet dataSet_;
    private HSSFWorkbook workbook_;
    private HSSFDataFormat dataFormat_;

    public XlsReader(String path) {
        this(ResourceUtil.getResourceAsStream((String)path));
    }

    public XlsReader(String dirName, String fileName) {
        this(ResourceUtil.getResourceAsFile((String)dirName), fileName);
    }

    public XlsReader(File dir, String fileName) {
        this(new File(dir, fileName));
    }

    public XlsReader(File file) {
        this(FileInputStreamUtil.create((File)file));
    }

    public XlsReader(InputStream in) {
        try {
            this.workbook_ = new HSSFWorkbook(in);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        this.dataFormat_ = this.workbook_.createDataFormat();
        this.dataSet_ = new DataSetImpl();
        for (int i = 0; i < this.workbook_.getNumberOfSheets(); ++i) {
            this.createTable(this.workbook_.getSheetName(i), this.workbook_.getSheetAt(i));
        }
    }

    public DataSet read() {
        return this.dataSet_;
    }

    private DataTable createTable(String sheetName, HSSFSheet sheet) {
        DataTable table = this.dataSet_.addTable(sheetName);
        int rowCount = sheet.getLastRowNum();
        if (rowCount > 0) {
            this.setupColumns(table, sheet.getRow(0), sheet.getRow(1));
            this.setupRows(table, sheet);
        } else if (rowCount == 0) {
            this.setupColumns(table, sheet.getRow(0), null);
        }
        return table;
    }

    private void setupColumns(DataTable table, HSSFRow nameRow, HSSFRow valueRow) {
        String columnName;
        HSSFCell nameCell;
        int i = 0;
        while ((nameCell = nameRow.getCell((short)i)) != null && (columnName = nameCell.getStringCellValue().trim()).length() != 0) {
            HSSFCell valueCell = null;
            if (valueRow != null) {
                valueCell = valueRow.getCell((short)i);
            }
            if (valueCell != null) {
                table.addColumn(columnName, this.getColumnType(valueCell));
            } else {
                table.addColumn(columnName);
            }
            ++i;
        }
    }

    private void setupRows(DataTable table, HSSFSheet sheet) {
        HSSFRow row;
        int i = 1;
        while ((row = sheet.getRow((int)((short)i))) != null) {
            this.setupRow(table, row);
            ++i;
        }
    }

    private void setupRow(DataTable table, HSSFRow row) {
        DataRow dataRow = table.addRow();
        for (int i = 0; i < table.getColumnSize(); ++i) {
            HSSFCell cell = row.getCell((short)i);
            Object value = this.getValue(cell);
            dataRow.setValue(i, value);
        }
    }

    public boolean isCellBase64Formatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        return "\\B\\:@".equals(this.dataFormat_.getFormat(dfNum));
    }

    public boolean isCellDateFormatted(HSSFCell cell) {
        HSSFCellStyle cs = cell.getCellStyle();
        short dfNum = cs.getDataFormat();
        String format = this.dataFormat_.getFormat(dfNum);
        if (StringUtil.isEmpty((String)format)) {
            return false;
        }
        return format.indexOf(47) > 0 || format.indexOf(121) > 0 || format.indexOf(109) > 0 || format.indexOf(100) > 0;
    }

    public Object getValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return TimestampConversionUtil.toTimestamp((Object)cell.getDateCellValue());
                }
                double numericCellValue = cell.getNumericCellValue();
                if (this.isInt(numericCellValue)) {
                    return new BigDecimal((double)((int)numericCellValue));
                }
                return new BigDecimal(Double.toString(numericCellValue));
            }
            case 1: {
                String s = cell.getStringCellValue();
                if (s != null) {
                    s = StringUtil.rtrim((String)s);
                }
                if ("".equals(s)) {
                    s = null;
                }
                if (this.isCellBase64Formatted(cell)) {
                    return Base64Util.decode((String)s);
                }
                return s;
            }
            case 4: {
                boolean b = cell.getBooleanCellValue();
                return b;
            }
        }
        return null;
    }

    protected ColumnType getColumnType(HSSFCell cell) {
        switch (cell.getCellType()) {
            case 0: {
                if (this.isCellDateFormatted(cell)) {
                    return ColumnTypes.TIMESTAMP;
                }
                return ColumnTypes.BIGDECIMAL;
            }
            case 1: {
                if (this.isCellBase64Formatted(cell)) {
                    return ColumnTypes.BINARY;
                }
                return ColumnTypes.STRING;
            }
        }
        return ColumnTypes.STRING;
    }

    private boolean isInt(double numericCellValue) {
        return (double)((int)numericCellValue) == numericCellValue;
    }
}

