/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.URLUtil;

public class WebResourceResolver
implements ResourceResolver {
    protected ResourceResolver parent;

    public WebResourceResolver() {
        this(new ClassPathResourceResolver());
    }

    public WebResourceResolver(ResourceResolver parent) {
        this.parent = parent;
    }

    public InputStream getInputStream(String path) {
        try {
            InputStream is;
            if (this.parent != null && (is = this.parent.getInputStream(path)) != null) {
                return is;
            }
            S2Container container = SingletonS2ContainerFactory.getContainer();
            ExternalContext externalContext = container.getExternalContext();
            if (externalContext == null) {
                return null;
            }
            if (!(externalContext.getApplication() instanceof ServletContext)) {
                return null;
            }
            ServletContext servletContext = (ServletContext)externalContext.getApplication();
            URL url = servletContext.getResource(path);
            if (url == null) {
                StringBuffer buf = new StringBuffer(path.length() + 10);
                buf.append("/WEB-INF");
                if (!path.startsWith("/")) {
                    buf.append("/");
                }
                buf.append(path);
                url = servletContext.getResource(new String(buf));
            }
            if (url == null) {
                return null;
            }
            return URLUtil.openStream(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

