/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.ContainerNotRegisteredRuntimeException;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationComponentDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.impl.S2ContainerComponentDef;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.container.impl.TooManyRegistrationComponentDefImpl;
import org.seasar.framework.container.ognl.S2ContainerPropertyAccessor;
import org.seasar.framework.container.util.MetaDefSupport;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.StringUtil;

public class S2ContainerImpl
implements S2Container,
ContainerConstants {
    private static Set notAssignableClasses = new HashSet();
    private Map componentDefMap = new HashMap();
    private List componentDefList = new ArrayList();
    private String namespace;
    private String path;
    private List children = new ArrayList();
    private Map childPositions = new HashMap();
    private List parents = new ArrayList();
    private CaseInsensitiveMap descendants = new CaseInsensitiveMap();
    private S2Container root;
    private ExternalContext externalContext;
    private ExternalContextComponentDefRegister externalContextComponentDefRegister;
    private MetaDefSupport metaDefSupport = new MetaDefSupport(this);
    private boolean inited = false;
    private boolean hotswapMode = false;
    private ClassLoader classLoader = null;
    static /* synthetic */ Class class$org$seasar$framework$container$S2Container;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$org$seasar$framework$container$ContainerConstants;
    static /* synthetic */ Class class$java$lang$Object;

    public S2ContainerImpl() {
        this.root = this;
        this.register0(new SimpleComponentDef((Object)this, "container"));
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public S2Container getRoot() {
        return this.root;
    }

    public void setRoot(S2Container root) {
        this.root = root;
    }

    public Object getComponent(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef cd = S2ContainerBehavior.acquireFromGetComponent(this, componentKey);
        if (cd == null) {
            return null;
        }
        return cd.getComponent();
    }

    public Object[] findComponents(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        ComponentDef[] componentDefs = this.findComponentDefs(componentKey);
        Object[] components = new Object[componentDefs.length];
        for (int i = 0; i < componentDefs.length; ++i) {
            components[i] = componentDefs[i].getComponent();
        }
        return components;
    }

    public void injectDependency(Object outerComponent) {
        this.injectDependency(outerComponent, outerComponent.getClass());
    }

    public void injectDependency(Object outerComponent, Class componentClass) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotNull(componentClass, "componentClass");
        ComponentDef cd = S2ContainerBehavior.acquireFromInjectDependency(this, componentClass);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    public void injectDependency(Object outerComponent, String componentName) {
        this.assertParameterIsNotNull(outerComponent, "outerComponent");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        ComponentDef cd = S2ContainerBehavior.acquireFromInjectDependency(this, componentName);
        if (cd != null) {
            cd.injectDependency(outerComponent);
        }
    }

    public void register(Object component) {
        this.assertParameterIsNotNull(component, "component");
        this.register(new SimpleComponentDef(component));
    }

    public void register(Object component, String componentName) {
        this.assertParameterIsNotNull(component, "component");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new SimpleComponentDef(component, componentName));
    }

    public void register(Class componentClass) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.register(new ComponentDefImpl(componentClass));
    }

    public void register(Class componentClass, String componentName) {
        this.assertParameterIsNotNull(componentClass, "componentClass");
        this.assertParameterIsNotEmpty(componentName, "componentName");
        this.register(new ComponentDefImpl(componentClass, componentName));
    }

    public synchronized void register(ComponentDef componentDef) {
        this.assertParameterIsNotNull(componentDef, "componentDef");
        this.register0(componentDef);
        this.componentDefList.add(componentDef);
    }

    protected void register0(ComponentDef componentDef) {
        if (componentDef.getContainer() == null) {
            componentDef.setContainer(this);
        }
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    protected void registerByClass(ComponentDef componentDef) {
        Class[] classes = S2ContainerImpl.getAssignableClasses(componentDef.getComponentClass());
        for (int i = 0; i < classes.length; ++i) {
            this.registerMap(classes[i], componentDef);
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        this.registerMap(key, componentDef, this);
    }

    public synchronized void registerMap(Object key, ComponentDef componentDef, S2Container container) {
        int position = this.getContainerPosition(container);
        ComponentDefHolder holder = (ComponentDefHolder)this.componentDefMap.get(key);
        if (holder == null) {
            holder = new ComponentDefHolder(position, componentDef);
            this.componentDefMap.put(key, holder);
        } else {
            if (position > holder.getPosition()) {
                return;
            }
            if (position < holder.getPosition()) {
                holder.setPosition(position);
                holder.setComponentDef(componentDef);
            } else if (container != this) {
                holder.setComponentDef(componentDef);
            } else {
                holder.setComponentDef(this.createTooManyRegistration(key, holder.getComponentDef(), componentDef));
            }
        }
        this.registerParent(key, holder.getComponentDef());
    }

    protected void registerParent(Object key, ComponentDef componentDef) {
        for (int i = 0; i < this.getParentSize(); ++i) {
            S2Container parent = this.getParent(i);
            parent.registerMap(key, componentDef, this);
            if (!this.isNeedNS(key, componentDef)) continue;
            parent.registerMap(this.namespace + '.' + key, componentDef, this);
        }
    }

    public synchronized int getComponentDefSize() {
        return this.componentDefList.size();
    }

    public synchronized ComponentDef getComponentDef(int index) {
        return (ComponentDef)this.componentDefList.get(index);
    }

    public ComponentDef getComponentDef(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        return S2ContainerBehavior.acquireFromGetComponentDef(this, key);
    }

    public ComponentDef[] findComponentDefs(Object key) throws ComponentNotFoundRuntimeException {
        this.assertParameterIsNotNull(key, "key");
        ComponentDef cd = this.internalGetComponentDef(key);
        if (cd == null) {
            return new ComponentDef[0];
        }
        if (cd instanceof TooManyRegistrationComponentDefImpl) {
            return ((TooManyRegistrationComponentDefImpl)cd).getComponentDefs();
        }
        return new ComponentDef[]{cd};
    }

    protected synchronized ComponentDef internalGetComponentDef(Object key) {
        String name;
        int index;
        ComponentDefHolder holder = (ComponentDefHolder)this.componentDefMap.get(key);
        if (holder != null) {
            return holder.getComponentDef();
        }
        if (key instanceof String && (index = (name = (String)key).indexOf(46)) > 0) {
            String ns = name.substring(0, index);
            name = name.substring(index + 1);
            if (ns.equals(this.namespace)) {
                return this.internalGetComponentDef(name);
            }
        }
        return null;
    }

    public boolean hasComponentDef(Object componentKey) {
        this.assertParameterIsNotNull(componentKey, "componentKey");
        return S2ContainerBehavior.acquireFromHasComponentDef(this, componentKey) != null;
    }

    public synchronized boolean hasDescendant(String path) {
        this.assertParameterIsNotEmpty(path, "path");
        return this.descendants.containsKey(path);
    }

    public synchronized S2Container getDescendant(String path) {
        S2Container descendant = (S2Container)this.descendants.get(path);
        if (descendant != null) {
            return descendant;
        }
        throw new ContainerNotRegisteredRuntimeException(path);
    }

    public synchronized void registerDescendant(S2Container descendant) {
        this.assertParameterIsNotNull(descendant, "descendant");
        this.descendants.put(descendant.getPath(), descendant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(S2Container child) {
        S2ContainerImpl s2ContainerImpl = this;
        synchronized (s2ContainerImpl) {
            this.assertParameterIsNotNull(child, "child");
            this.children.add(child);
            this.childPositions.put(child, new Integer(this.children.size()));
        }
        child.setRoot(this.getRoot());
        child.addParent(this);
    }

    protected int getContainerPosition(S2Container container) {
        if (container == this) {
            return 0;
        }
        return (Integer)this.childPositions.get(container);
    }

    protected boolean isNeedNS(Object key, ComponentDef cd) {
        return key instanceof String && this.namespace != null;
    }

    public synchronized int getChildSize() {
        return this.children.size();
    }

    public synchronized S2Container getChild(int index) {
        return (S2Container)this.children.get(index);
    }

    public synchronized int getParentSize() {
        return this.parents.size();
    }

    public synchronized S2Container getParent(int index) {
        return (S2Container)this.parents.get(index);
    }

    public synchronized void addParent(S2Container parent) {
        this.parents.add(parent);
        Iterator it = this.componentDefMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            ComponentDefHolder holder = (ComponentDefHolder)entry.getValue();
            ComponentDef cd = holder.getComponentDef();
            parent.registerMap(key, cd, this);
            if (!this.isNeedNS(key, cd)) continue;
            parent.registerMap(this.namespace + '.' + key, cd, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        ExternalContextComponentDefRegister register = this.getRoot().getExternalContextComponentDefRegister();
        if (register != null) {
            register.registerComponentDefs(this);
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = 0; i < this.getChildSize(); ++i) {
                this.getChild(i).init();
            }
            for (i = 0; i < this.getComponentDefSize(); ++i) {
                this.getComponentDef(i).init();
            }
            this.inited = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.inited) {
            return;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            int i;
            for (i = this.getComponentDefSize() - 1; 0 <= i; --i) {
                try {
                    this.getComponentDef(i).destroy();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            for (i = this.getChildSize() - 1; 0 <= i; --i) {
                this.getChild(i).destroy();
            }
            this.inited = false;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public synchronized void setNamespace(String namespace) {
        this.componentDefMap.remove(namespace);
        this.namespace = namespace;
        this.registerMap(namespace, new S2ContainerComponentDef(this, namespace));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
        return this.externalContextComponentDefRegister;
    }

    public void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister register) {
        this.externalContextComponentDefRegister = register;
    }

    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }

    public boolean isHotswapMode() {
        return this.hotswapMode;
    }

    public void setHotswapMode(boolean hotswapMode) {
        this.hotswapMode = hotswapMode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected static Class[] getAssignableClasses(Class componentClass) {
        HashSet classes = new HashSet();
        for (Class clazz = componentClass; clazz != (class$java$lang$Object == null ? S2ContainerImpl.class$("java.lang.Object") : class$java$lang$Object) && clazz != null; clazz = clazz.getSuperclass()) {
            S2ContainerImpl.addAssignableClasses(classes, clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected static void addAssignableClasses(Set classes, Class clazz) {
        if (notAssignableClasses.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            S2ContainerImpl.addAssignableClasses(classes, interfaces[i]);
        }
    }

    protected ComponentDef createTooManyRegistration(Object key, ComponentDef currentComponentDef, ComponentDef newComponentDef) {
        if (currentComponentDef instanceof TooManyRegistrationComponentDef) {
            ((TooManyRegistrationComponentDef)currentComponentDef).addComponentDef(newComponentDef);
            return currentComponentDef;
        }
        TooManyRegistrationComponentDefImpl tmrcf = new TooManyRegistrationComponentDefImpl(key);
        tmrcf.addComponentDef(currentComponentDef);
        tmrcf.addComponentDef(newComponentDef);
        return tmrcf;
    }

    protected void assertParameterIsNotNull(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name);
        }
    }

    protected void assertParameterIsNotEmpty(String parameter, String name) {
        if (StringUtil.isEmpty(parameter)) {
            throw new IllegalArgumentException(name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OgnlRuntime.setPropertyAccessor((Class)(class$org$seasar$framework$container$S2Container == null ? (class$org$seasar$framework$container$S2Container = S2ContainerImpl.class$("org.seasar.framework.container.S2Container")) : class$org$seasar$framework$container$S2Container), (PropertyAccessor)new S2ContainerPropertyAccessor());
        notAssignableClasses.add(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = S2ContainerImpl.class$("java.lang.Cloneable")) : class$java$lang$Cloneable);
        notAssignableClasses.add(class$java$lang$Comparable == null ? (class$java$lang$Comparable = S2ContainerImpl.class$("java.lang.Comparable")) : class$java$lang$Comparable);
        notAssignableClasses.add(class$java$io$Serializable == null ? (class$java$io$Serializable = S2ContainerImpl.class$("java.io.Serializable")) : class$java$io$Serializable);
        notAssignableClasses.add(class$java$io$Externalizable == null ? (class$java$io$Externalizable = S2ContainerImpl.class$("java.io.Externalizable")) : class$java$io$Externalizable);
        notAssignableClasses.add(class$org$seasar$framework$container$ContainerConstants == null ? (class$org$seasar$framework$container$ContainerConstants = S2ContainerImpl.class$("org.seasar.framework.container.ContainerConstants")) : class$org$seasar$framework$container$ContainerConstants);
    }

    static class ComponentDefHolder {
        private int position;
        private ComponentDef componentDef;

        public ComponentDefHolder(int position, ComponentDef componentDef) {
            this.position = position;
            this.componentDef = componentDef;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public ComponentDef getComponentDef() {
            return this.componentDef;
        }

        public void setComponentDef(ComponentDef componentDef) {
            this.componentDef = componentDef;
        }
    }
}

