/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;

import org.jenia.faces.chart.util.ChartBean;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;

public class BarChart3D extends ChartBean {
	
	private String title;
	private String xAxisLabel;
	private String yAxisLabel;
	private CategoryDataset dataset;
	private NumberFormat formatter;
	private double upperMargin;
	private double labelAngle;
	private boolean includeZero;
	private boolean labelVisibility;
	private BasicStroke[] basicStroke; 
	private boolean includeLegend;
	private boolean includeTooltips;
	private boolean includeUrls;
	private PlotOrientation orientation;
	private Color color;
	private String type;
	private float transparency;
	private Color plotColor;	
	private String xAxisOrientation;
	private double unit;
	private Paint[] paint;
	
	public BarChart3D() {
	}
	
	public BarChart3D(BasicStroke[] stroke, Color color, CategoryDataset dataset, NumberFormat formatter, boolean legend, boolean tooltips, boolean urls, boolean zero, double angle, boolean visibility, PlotOrientation orientation, String title, double margin, String label, String label2, int width, int height, String type, float transparency, Color plotColor, String xAxisOrientation, double unit, Paint[] paint) {
		this.basicStroke = stroke;
		this.color = color;
		this.dataset = dataset;
		this.formatter = formatter;
		this.includeLegend = legend;
		this.includeTooltips = tooltips;
		this.includeUrls = urls;
		this.includeZero = zero;
		this.labelAngle = angle;
		this.labelVisibility = visibility;
		this.orientation = orientation;
		this.title = title;
		this.upperMargin = margin;
		this.xAxisLabel = label;
		this.yAxisLabel = label2;
		super.width = width;
		super.height = height;
		this.type = type;
		this.transparency = transparency;
		this.plotColor = plotColor;
		this.xAxisOrientation = xAxisOrientation;
		this.unit = unit;
		this.paint = paint;
	}




	protected JFreeChart getChart() {
		if (type.equals("StackedBar"))
			return createStackedBarChart3D(title,
					xAxisLabel,
					yAxisLabel,
					dataset,
					formatter,
					upperMargin,
					labelAngle,
					includeZero,
					labelVisibility,
					basicStroke, 
					includeLegend,
					includeTooltips,
					includeUrls,
					orientation,
					color,
					transparency,
					plotColor,
					xAxisOrientation,
					unit,
					paint);
		else if (type.equals("Line"))
			return createLineChart(title,
					xAxisLabel,
					yAxisLabel,
					dataset,
					formatter,
					upperMargin,
					labelAngle,
					includeZero,
					labelVisibility,
					basicStroke, 
					includeLegend,
					includeTooltips,
					includeUrls,
					orientation,
					color,
					transparency,
					plotColor,
					xAxisOrientation,
					unit,
					paint);
		else if (type.equals("Area"))
			return createAreaChart(title,
					xAxisLabel,
					yAxisLabel,
					dataset,
					formatter,
					upperMargin,
					labelAngle,
					includeZero,
					labelVisibility,
					basicStroke, 
					includeLegend,
					includeTooltips,
					includeUrls,
					orientation,
					color,
					transparency,
					plotColor,
					xAxisOrientation,
					unit,
					paint);
		else if (type.equals("BarChart2D")) {
			return createBarChart(title,
					xAxisLabel,
					yAxisLabel,
					dataset,
					formatter,
					upperMargin,
					labelAngle,
					includeZero,
					labelVisibility,
					basicStroke, 
					includeLegend,
					includeTooltips,
					includeUrls,
					orientation,
					color,
					transparency,
					plotColor,
					xAxisOrientation,
					unit,
					paint);
		} else
			return createBarChart3D(title,
					xAxisLabel,
					yAxisLabel,
					dataset,
					formatter,
					upperMargin,
					labelAngle,
					includeZero,
					labelVisibility,
					basicStroke, 
					includeLegend,
					includeTooltips,
					includeUrls,
					orientation,
					color,
					transparency,
					plotColor,
					xAxisOrientation,
					unit,
					paint);		
	}

}
