package org.jenia.faces.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.text.NumberFormat;

import org.jenia.faces.chart.util.ChartBean;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramChart extends ChartBean {

	private String title;
	private String xAxisLabel;
	private String yAxisLabel;
	private IntervalXYDataset dataset;
	private NumberFormat formatter;
	private double upperMargin;
	private double labelAngle;
	private boolean includeZero;
	private boolean labelVisibility;
	private BasicStroke[] basicStroke; 
	private boolean includeLegend;
	private boolean includeTooltips;
	private boolean includeUrls;
	private PlotOrientation orientation;
	private Color color;
	private String type;
	private float transparency;
	private Color plotColor;	
	private String xAxisOrientation;
	private double unit;
	
	public HistogramChart() {
	}
	
	public HistogramChart(BasicStroke[] stroke, Color color, IntervalXYDataset dataset, NumberFormat formatter, boolean legend, boolean tooltips, boolean urls, boolean zero, double angle, boolean visibility, PlotOrientation orientation, String title, double margin, String label, String label2, int width, int height, String type, float transparency, Color plotColor, String xAxisOrientation, double unit) {
		this.basicStroke = stroke;
		this.color = color;
		this.dataset = dataset;
		this.formatter = formatter;
		this.includeLegend = legend;
		this.includeTooltips = tooltips;
		this.includeUrls = urls;
		this.includeZero = zero;
		this.labelAngle = angle;
		this.labelVisibility = visibility;
		this.orientation = orientation;
		this.title = title;
		this.upperMargin = margin;
		this.xAxisLabel = label;
		this.yAxisLabel = label2;
		super.width = width;
		super.height = height;
		this.type = type;
		this.transparency = transparency;
		this.plotColor = plotColor;
		this.xAxisOrientation = xAxisOrientation;
		this.unit = unit;
	}
	
	
	protected JFreeChart getChart() {
		return createHistogramChart(title,
				xAxisLabel,
				yAxisLabel,
				dataset,
				formatter,
				upperMargin,
				labelAngle,
				includeZero,
				labelVisibility,
				basicStroke, 
				includeLegend,
				includeTooltips,
				includeUrls,
				orientation,
				color,
				transparency,
				plotColor,
				xAxisOrientation,
				unit);
	}

}
