/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart;

import java.awt.Color;

import org.jenia.faces.chart.util.ChartBean;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.PieDataset;
/**
 * @author NecciM
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class PieChart3D extends ChartBean {

	private PieDataset dataSet;
	private String titolo;
	private Color color;
	private Color plotColor;
	private float transparency;
	private boolean crush;

	public  PieChart3D() {
	}
	
	public PieChart3D(String titolo, PieDataset dataSet, Color color, float transparency, int witdh, int height, Color plotColor, boolean crush) {
		this.dataSet = dataSet;
		this.titolo = titolo;
		this.color = color;
		this.transparency = transparency;
		super.width = witdh;
		super.height = height;
		this.plotColor = plotColor;
		this.crush = crush;
	}
	
	public JFreeChart getChart() {
		return createPieChart3D(titolo, dataSet, color, transparency, plotColor, crush);
	}
	
		
}
