/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart.component;

import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class UIChart extends UIGraphic {
	
	protected String color;
	protected String width;
	protected String height;	
	protected String chartTitle;
	protected String style;
	protected String styleClass;
	protected String title;	
	protected String fileExt;
	protected String transparency;
	protected String plotColor;
	
    public String getFamily() {
        return "org.jenia.faces.Chart";
    }

	public String getHeight() {
		if (null != this.height) {
			return this.height;
		}
		ValueBinding _vb = getValueBinding("height");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getWidth() {
		if (null != this.width) {
			return this.width;
		}
		ValueBinding _vb = getValueBinding("width");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public String getChartTitle() {
		if (null != this.chartTitle) {
			return this.chartTitle;
		}
		ValueBinding _vb = getValueBinding("chartTitle");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setChartTitle(String chartTitle) {
		this.chartTitle = chartTitle;
	}
	public String getStyle() {
		if (null != this.style) {
			return this.style;
		}
		ValueBinding _vb = getValueBinding("style");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public String getStyleClass() {
		if (null != this.styleClass) {
			return this.styleClass;
		}
		ValueBinding _vb = getValueBinding("styleClass");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	public String getTitle() {
		if (null != this.title) {
			return this.title;
		}
		ValueBinding _vb = getValueBinding("title");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getColor() {
		if (null != this.color) {
			return this.color;
		}
		ValueBinding _vb = getValueBinding("color");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setColor(String color) {
		this.color = color;
	}

	public String getFileExt() {
		if (null != this.fileExt) {
			return this.fileExt;
		}
		ValueBinding _vb = getValueBinding("fileExt");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setFileExt(String fileExt) {
		this.fileExt = fileExt;
	}

	public String getTransparency() {
		if (null != this.transparency) {
			return this.transparency;
		}
		ValueBinding _vb = getValueBinding("transparency");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setTransparency(String transparency) {
		this.transparency = transparency;
	}

	public String getPlotColor() {
		if (null != this.plotColor) {
			return this.plotColor;
		}
		ValueBinding _vb = getValueBinding("plotColor");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}

	public void setPlotColor(String plotColor) {
		this.plotColor = plotColor;
	}	
	
    public Object saveState(FacesContext _context) {
        Object _values[] = new Object[11];
        _values[0] = super.saveState(_context);
        _values[1] = color;
        _values[2] = width;
        _values[3] = height;
        _values[4] = chartTitle;
        _values[5] = style;
        _values[6] = styleClass;
        _values[7] = title;
        _values[8] = fileExt;
        _values[9] = transparency;
        _values[10] = plotColor;
        
        return _values;
      }

	public void restoreState(FacesContext _context, Object _state) {
        Object _values[] = (Object[]) _state;
        super.restoreState(_context, _values[0]);
        color = (String)_values[1];
        width = (String)_values[2];
        height = (String)_values[3];
        chartTitle = (String)_values[4];
        style = (String)_values[5];
        styleClass = (String)_values[6];
        title = (String)_values[7];
        fileExt = (String)_values[8];
        transparency = (String)_values[9];
        plotColor = (String)_values[10];        
	}	

}
