package org.jenia.faces.chart.component.html;

import java.awt.BasicStroke;
import java.text.NumberFormat;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.jenia.faces.chart.component.UIChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;

public class HtmlHistogramChart extends UIChart {
	
    public static final String COMPONENT_TYPE = "org.jenia.faces.chart.HtmlHistogramChart";
    public static final String RENDERER_TYPE = "org.jenia.faces.chart.HistogramChart";
    
	private String axisXLabel;
	private String axisYLabel;
	private IntervalXYDataset dataset;
	private NumberFormat formatter;
	private String upperMargin;
	private String labelAngle;
	private String includeZero;
	private String labelVisibility;
	private BasicStroke[] basicStroke; 
	private String includeLegend;
	private String includeTooltips;
	private String includeUrls;
	private PlotOrientation orientation;
	private String type;
	private String xAxisOrientation;
	private String tickUnit;
    

	public HtmlHistogramChart() {
		super();
        setRendererType(RENDERER_TYPE);
	}


	public BasicStroke[] getBasicStroke() {
        if (null != this.basicStroke) {
            return this.basicStroke;
        }
        ValueBinding _vb = getValueBinding("basicStroke");
        if (_vb != null) {
            return (BasicStroke[]) _vb.getValue(getFacesContext());
        } else {
            return null;
        }	}


	public void setBasicStroke(BasicStroke[] basicStroke) {
		this.basicStroke = basicStroke;
	}


	public IntervalXYDataset getDataset() {
        if (null != this.dataset) {
            return this.dataset;
        }
        ValueBinding _vb = getValueBinding("dataset");
        if (_vb != null) {
            return (IntervalXYDataset) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }


	public void setDataset(IntervalXYDataset dataset) {
		this.dataset = dataset;
	}


	public NumberFormat getFormatter() {
        if (null != this.formatter) {
            return this.formatter;
        }
        ValueBinding _vb = getValueBinding("formatter");
        if (_vb != null) {
            return (NumberFormat) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
	}


	public void setFormatter(NumberFormat formatter) {
		this.formatter = formatter;
	}


	public String getIncludeLegend() {
		if (null != this.includeLegend) {
			return this.includeLegend;
		}
		ValueBinding _vb = getValueBinding("includeLegend");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setIncludeLegend(String includeLegend) {
		this.includeLegend = includeLegend;
	}


	public String getIncludeTooltips() {
		if (null != this.includeTooltips) {
			return this.includeTooltips;
		}
		ValueBinding _vb = getValueBinding("includeTooltips");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setIncludeTooltips(String includeTooltips) {
		this.includeTooltips = includeTooltips;
	}


	public String getIncludeUrls() {
		if (null != this.includeUrls) {
			return this.includeUrls;
		}
		ValueBinding _vb = getValueBinding("includeUrls");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setIncludeUrls(String includeUrls) {
		this.includeUrls = includeUrls;
	}


	public String getIncludeZero() {
		if (null != this.includeZero) {
			return this.includeZero;
		}
		ValueBinding _vb = getValueBinding("includeZero");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setIncludeZero(String includeZero) {
		this.includeZero = includeZero;
	}


	public String getLabelAngle() {
		if (null != this.labelAngle) {
			return this.labelAngle;
		}
		ValueBinding _vb = getValueBinding("labelAngle");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setLabelAngle(String labelAngle) {
		this.labelAngle = labelAngle;
	}


	public String getLabelVisibility() {
		if (null != this.labelVisibility) {
			return this.labelVisibility;
		}
		ValueBinding _vb = getValueBinding("labelVisibility");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setLabelVisibility(String labelVisibility) {
		this.labelVisibility = labelVisibility;
	}


	public PlotOrientation getOrientation() {
        if (null != this.orientation) {
            return this.orientation;
        }
        ValueBinding _vb = getValueBinding("orientation");
        if (_vb != null) {
            return (PlotOrientation) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
	}


	public void setOrientation(PlotOrientation orientation) {
		this.orientation = orientation;
	}


	public String getUpperMargin() {
		if (null != this.upperMargin) {
			return this.upperMargin;
		}
		ValueBinding _vb = getValueBinding("upperMargin");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setUpperMargin(String upperMargin) {
		this.upperMargin = upperMargin;
	}


	public String getAxisXLabel() {
		if (null != this.axisXLabel) {
			return this.axisXLabel;
		}
		ValueBinding _vb = getValueBinding("axisXLabel");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setAxisXLabel(String axisXLabel) {
		this.axisXLabel = axisXLabel;
	}


	public String getAxisYLabel() {
		if (null != this.axisYLabel) {
			return this.axisYLabel;
		}
		ValueBinding _vb = getValueBinding("axisYLabel");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setAxisYLabel(String axisYLabel) {
		this.axisYLabel = axisYLabel;
	}


	public String getType() {
		if (null != this.type) {
			return this.type;
		}
		ValueBinding _vb = getValueBinding("type");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setType(String type) {
		this.type = type;
	}
	
	public String getXAxisOrientation() {
		if (null != this.xAxisOrientation) {
			return this.xAxisOrientation;
		}
		ValueBinding _vb = getValueBinding("xAxisOrientation");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}
	}


	public void setXAxisOrientation(String axisOrientation) {
		xAxisOrientation = axisOrientation;
	}	
	
	public String getTickUnit() {
		if (null != this.tickUnit) {
			return this.tickUnit;
		}
		ValueBinding _vb = getValueBinding("tickUnit");
		if (_vb != null) {
			return (java.lang.String) _vb.getValue(getFacesContext());
		} else {
			return null;
		}	}


	public void setTickUnit(String tickUnit) {
		this.tickUnit = tickUnit;
	}	
	
    public Object saveState(FacesContext _context) {
        Object _values[] = new Object[17];
        _values[0] = super.saveState(_context);     
        _values[1] = axisXLabel;
        _values[2] = axisYLabel;
        _values[3] = dataset;
        _values[4] = formatter;
        _values[5] = upperMargin;
        _values[6] = labelAngle;
        _values[7] = includeZero;
        _values[8] = labelVisibility;
        _values[9] = basicStroke;
        _values[10] = includeLegend;
        _values[11] = includeTooltips;
        _values[12] = includeUrls;
        _values[13] = orientation;
        _values[14] = type;
        _values[15] = xAxisOrientation;
        _values[16] = tickUnit;
        return _values;
      }

	public void restoreState(FacesContext _context, Object _state) {
        Object _values[] = (Object[]) _state;
        super.restoreState(_context, _values[0]);        
    	axisXLabel = (String)_values[1];
    	axisYLabel = (String)_values[2];
    	dataset = (IntervalXYDataset)_values[3];
    	formatter = (NumberFormat)_values[4];
    	upperMargin = (String)_values[5];
    	labelAngle = (String)_values[6];
    	includeZero = (String)_values[7];
    	labelVisibility = (String)_values[8];
    	basicStroke = (BasicStroke[])_values[9];
    	includeLegend = (String)_values[10];
    	includeTooltips = (String)_values[11];
    	includeUrls = (String)_values[12];
    	orientation = (PlotOrientation)_values[13];
    	type = (String)_values[14];
    	xAxisOrientation = (String)_values[15];
    	tickUnit = (String)_values[16];
	}	

}
