/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart.component.html;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.jenia.faces.chart.component.UIChart;
import org.jfree.data.general.PieDataset;

public class HtmlPieChart3D extends UIChart {
	
    public static final String COMPONENT_TYPE = "org.jenia.faces.chart.HtmlPieChart3D";
    public static final String RENDERER_TYPE = "org.jenia.faces.chart.PieChart3D";
	
	private PieDataset pieDataSet;
	private String crush;
	
	public HtmlPieChart3D() {
		super();
        setRendererType(RENDERER_TYPE);
	}	
	public PieDataset getPieDataSet() {
        if (null != this.pieDataSet) {
            return this.pieDataSet;
        }
        ValueBinding _vb = getValueBinding("pieDataSet");
        if (_vb != null) {
            return (PieDataset) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
	}
	public void setPieDataSet(PieDataset pieDataSet) {
		this.pieDataSet = pieDataSet;
	}
	
    public String getCrush() {
        if (null != this.crush) {
            return this.crush;
        }
        ValueBinding _vb = getValueBinding("crush");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
	}
	public void setCrush(String crush) {
		this.crush = crush;
	}
	public Object saveState(FacesContext _context) {
        Object _values[] = new Object[3];
        _values[0] = super.saveState(_context);
        _values[1] = pieDataSet;
        _values[2] = crush;
        
        return _values;
      }

	public void restoreState(FacesContext _context, Object _state) {
        Object _values[] = (Object[]) _state;
        super.restoreState(_context, _values[0]);
        pieDataSet = (PieDataset)_values[1];     
        crush = (String)_values[2];
	}	

}
