/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart.renderkit.html;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.jenia.faces.renderkit.html.HtmlBasicRenderer;
import org.jenia.faces.util.Util;

public class ChartRenderer extends HtmlBasicRenderer{

    protected void commonJavascript(FacesContext context, UIComponent component) throws IOException {
        super.commonJavascript(context,component);
        ResponseWriter rw = context.getResponseWriter();
        //if (Util.getRequest().getAttribute("jenia.org.js")==null) {
            Util.setRequestAttribute("jenia.org.js","ok");
            rw.startElement("script",component);
            rw.writeAttribute("language","JavaScript",null);
            rw.writeAttribute("src",Util.internalPath("/chart/js/jenia.js"),null);
            rw.endElement("script");
        //}
    }	

}
