package org.jenia.faces.chart.renderkit.html;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.IOException;
import java.text.NumberFormat;

import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.jenia.faces.chart.HistogramChart;
import org.jenia.faces.chart.component.html.HtmlHistogramChart;
import org.jenia.faces.chart.util.ChartBean;
import org.jenia.faces.util.Util;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramChartRenderer extends ChartRenderer {
	
    public boolean getRendersChildren() {
		return false;
	}	

    protected UIForm getMyForm(FacesContext context, UIPanel panel) {
        UIComponent parent = panel.getParent();
        while (parent != null) {
            if (parent instanceof UIForm) {
                break;
            }
            parent = parent.getParent();
        }
        return (UIForm)parent;
    } 
	
	public void encodeBegin(FacesContext context, UIComponent component)
    throws IOException {

		HtmlHistogramChart chart = (HtmlHistogramChart)component;

		// suppress rendering if "rendered" property on the command is
		// false.
		if (!chart.isRendered()) {
		    return;
		}
		
		UIForm uiform = getMyForm(context, chart);
		if ( uiform == null ) {
		    //Object[] params = {};
		    throw new RuntimeException("JSF h:Form needed to use this component");
		}			
		
		String titolo = chart.getChartTitle();
		IntervalXYDataset dataSet = chart.getDataset();
		Color graphColor = ChartBean.getColor(chart.getColor());
		Color plotColor = ChartBean.getColor(chart.getPlotColor());
		int width = new Integer(chart.getWidth()).intValue();
		int height = new Integer(chart.getHeight()).intValue();
		String xAxisLabel = chart.getAxisXLabel();
		String yAxisLabel = chart.getAxisYLabel();
		NumberFormat format = chart.getFormatter();
		String upperMargin = chart.getUpperMargin();
		if (upperMargin == null)
			upperMargin = "0.20";
		String labelAngle = chart.getLabelAngle();
		double angle;
		if (labelAngle==null)
			angle = Math.PI * 2.0;
		else 
			angle = new Double(labelAngle).doubleValue();
		String tickUnit = chart.getTickUnit();
		double unit;
		if (tickUnit == null) {
			unit = new Double(Double.MIN_VALUE).doubleValue();
		} else  {
			unit = new Double(tickUnit).doubleValue();
		}
		String includeZero = chart.getIncludeZero();
		String labelVisibility = chart.getLabelVisibility();
		BasicStroke[] basicStroke = chart.getBasicStroke(); 
		String includeLegend = chart.getIncludeLegend();
		if (includeLegend==null)
			includeLegend = "true";
		String includeTooltips = chart.getIncludeTooltips();
		String includeUrls = chart.getIncludeUrls();
		PlotOrientation orientation = chart.getOrientation();				
		String fileExt = ChartBean.getFileExt(chart.getFileExt().toLowerCase());	
		String chartType = "Histogram";
		String xAxisOrientation = chart.getXAxisOrientation();
		if (xAxisOrientation == null)
			xAxisOrientation = "";
		float transparency;
		if (chart.getTransparency() == null)
			transparency = 1.0f;
		else
			transparency = new Float(chart.getTransparency()).floatValue();

		HistogramChart histogramChart = new HistogramChart(basicStroke,
				graphColor,
				dataSet,
				format,
				new Boolean(includeLegend).booleanValue(),
				new Boolean(includeTooltips).booleanValue(), 
				new Boolean(includeUrls).booleanValue(), 
				new Boolean(includeZero).booleanValue(), 
				angle, 
				new Boolean(labelVisibility).booleanValue(), 
				orientation,
				titolo,
				new Double(upperMargin).doubleValue(),
				xAxisLabel,
				yAxisLabel,
				width,
				height,
				chartType,
				transparency,
				plotColor,
				xAxisOrientation,
				unit);

		String url = context.getViewRoot().getViewId()+ "HistogramChart" + chart.getId() + "." + fileExt;
		
		setFacesBean(url , histogramChart);
		
		//String formClientId = uiform.getClientId(context);
		ResponseWriter rw = context.getResponseWriter();
		
		if (fileExt.equals("png") || fileExt.equals("jpg")) {
		
			rw.startElement("img",chart);
			//rw.writeAttribute("src", Util.internalPath("/chart" + url), null);
			rw.writeAttribute("src", Util.getFacesContext().getExternalContext().encodeResourceURL(Util.internalPath("/chart" + url)), null);
			
			String cl = chart.getStyleClass();
			if (cl != null && !cl.equals("")) {
				rw.writeAttribute("class", cl, "labelClass");
			}
	
			// handle style
			String style = chart.getStyle();
			if (style != null) {
				rw.writeAttribute("style", style, "style");
			}
	
			// handle title
			String title = chart.getTitle();
			if (title != null) {
				rw.writeAttribute("title", title, "title");
			}	
		
			rw.endElement("img");			
		} else if (chart.getFileExt().equals("svg")) {
			rw.startElement("embed",chart);
			//rw.writeAttribute("src", Util.internalPath("/chart" + url), null);
			rw.writeAttribute("src", Util.getFacesContext().getExternalContext().encodeResourceURL(Util.internalPath("/chart" + url)), null);			
			rw.writeAttribute("width", new Integer(width), null);
			rw.writeAttribute("height", new Integer(height), null);
			rw.writeAttribute("type", "image/svg-xml", null);
			rw.writeAttribute("pluginspage", "http://www.adobe.com/svg/viewer/install/main.html", null);
			rw.endElement("embed");			
		}

		rw.flush();
	}
	
    public void encodeChildren(FacesContext context, UIComponent component)
    throws IOException {	
		return;
	}
	
	public void encodeEnd(FacesContext context, UIComponent component)
	    throws IOException {
		return;
	}
	
	public static final void setFacesBean(String name, Object bean) {
		//Util.getApplication().createValueBinding("#{"+name+"}").setValue(Util.getFacesContext(), bean);
		Util.setSessionAttribute(name, bean);	
	}	

}
