/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart.taglib;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentBodyTag;

import org.jenia.faces.chart.component.UIChart;
import org.jenia.faces.chart.component.html.HtmlPieChart3D;
import org.jenia.faces.util.Util;

public class ChartTag  extends UIComponentBodyTag {
	
	protected String chartTitle;
	protected String color;
	protected String width;
	protected String height;
	protected String style;
	protected String styleClass;
	protected String title;	
	protected String fileExt;
	protected String transparency;
	protected String plotColor;
	
	public String getComponentType() {
		return HtmlPieChart3D.COMPONENT_TYPE;
	}
	public String getRendererType() {
		return HtmlPieChart3D.RENDERER_TYPE;
	}
	
	public void setColor(String color) {
		this.color = color;
	}
	public void setHeight(String height) {
		this.height = height;
	}
	public void setWidth(String width) {
		this.width = width;
	}
	public void setStyle(String style) {
		this.style = style;
	}
	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	public void setTitle(String title) {
		this.title = title;
	}	
	
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        UIChart chart = null;
        try {
			chart = (UIChart)component;
        }
        catch (ClassCastException cce) {
          throw new IllegalStateException("Component " + component.toString() + " not expected type.  Expected: UIPanel.  Perhaps you're missing a tag?");
        }
		
        if (title != null) {
            if (isValueReference(title)) {
                ValueBinding vb = Util.getValueBinding(title);
				chart.setValueBinding("title", vb);
            } else {
				chart.setTitle(title);
            }
        }
        if (color != null) {
            if (isValueReference(color)) {
                ValueBinding vb = Util.getValueBinding(color);
				chart.setValueBinding("color", vb);
            } else {
				chart.setColor(color);
            }
        }	
        if (width != null) {
            if (isValueReference(width)) {
                ValueBinding vb = Util.getValueBinding(width);
				chart.setValueBinding("width", vb);
            } else {
				chart.setWidth(width);
            }
        }
        if (height != null) {
            if (isValueReference(height)) {
                ValueBinding vb = Util.getValueBinding(height);
				chart.setValueBinding("height", vb);
            } else {
				chart.setHeight(height);
            }
        }	
        if (style != null) {
            if (isValueReference(style)) {
                ValueBinding vb = Util.getValueBinding(style);
				chart.setValueBinding("style", vb);
            } else {
				chart.setStyle(style);
            }
        }		
		if (styleClass != null) {
			if (isValueReference(styleClass)) {
				ValueBinding vb = Util.getValueBinding(styleClass);
				chart.setValueBinding("styleClass", vb);
			} else {
				chart.setStyleClass(styleClass);
			}
		}
		if (chartTitle != null) {
			if (isValueReference(chartTitle)) {
				ValueBinding vb = Util.getValueBinding(chartTitle);
				chart.setValueBinding("chartTitle", vb);
			} else {
				chart.setChartTitle(chartTitle);
			}
		}	
		if (fileExt != null) {
			if (isValueReference(fileExt)) {
				ValueBinding vb = Util.getValueBinding(fileExt);
				chart.setValueBinding("fileExt", vb);
			} else {
				chart.setFileExt(fileExt);
			}
		}		
		if (transparency != null) {
			if (isValueReference(transparency)) {
				ValueBinding vb = Util.getValueBinding(transparency);
				chart.setValueBinding("transparency", vb);
			} else {
				chart.setTransparency(transparency);
			}
		}	
		if (plotColor != null) {
			if (isValueReference(plotColor)) {
				ValueBinding vb = Util.getValueBinding(plotColor);
				chart.setValueBinding("plotColor", vb);
			} else {
				chart.setPlotColor(plotColor);
			}
		}		
    }
	public void setChartTitle(String chartTitle) {
		this.chartTitle = chartTitle;
	}
	public void setFileExt(String fileExt) {
		this.fileExt = fileExt;
	}
	public void setTransparency(String transparency) {
		this.transparency = transparency;
	}
	public void setPlotColor(String plotColor) {
		this.plotColor = plotColor;
	}
	
	

}
