package org.jenia.faces.chart.taglib;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;

import org.jenia.faces.chart.component.html.HtmlHistogramChart;
import org.jenia.faces.util.Util;

public class HistogramChartTag extends ChartTag {
	
	private String axisXLabel;
	private String axisYLabel;
	private String dataset;
	private String formatter;
	private String upperMargin;
	private String labelAngle;
	private String includeZero;
	private String labelVisibility;
	private String basicStroke; 
	private String includeLegend;
	private String includeTooltips;
	private String includeUrls;
	private String orientation;		
	private String type;
	private String xAxisOrientation;	
	private String tickUnit;
	
	
	public String getComponentType() {
		return HtmlHistogramChart.COMPONENT_TYPE;
	}
	public String getRendererType() {
		return HtmlHistogramChart.RENDERER_TYPE;
	}
	
	protected void setProperties(UIComponent component) {
	    super.setProperties(component);
	    HtmlHistogramChart chart = null;
	    try {
			chart = (HtmlHistogramChart)component;
	    }
	    catch (ClassCastException cce) {
	      throw new IllegalStateException("Component " + component.toString() + " not expected type.  Expected: UIPanel.  Perhaps you're missing a tag?");
	    }
	    if (axisXLabel != null) {
	        if (isValueReference(axisXLabel)) {
	            ValueBinding vb = Util.getValueBinding(axisXLabel);
				chart.setValueBinding("axisXLabel", vb);
	        } else {
				chart.setAxisXLabel(axisXLabel);
	        }
	    }		
	    if (axisYLabel != null) {
	        if (isValueReference(axisYLabel)) {
	            ValueBinding vb = Util.getValueBinding(axisYLabel);
				chart.setValueBinding("axisYLabel", vb);
	        } else {
				chart.setAxisYLabel(axisYLabel);
	        }
	    }		
	    if (dataset != null) {
	        if (isValueReference(dataset)) {
	            ValueBinding vb = Util.getValueBinding(dataset);
				chart.setValueBinding("dataset", vb);
	        } else {
		        throw new IllegalStateException("Invalid dataset reference : " + dataset);
	        }
	    }		
	    if (formatter != null) {
	        if (isValueReference(formatter)) {
	            ValueBinding vb = Util.getValueBinding(formatter);
				chart.setValueBinding("formatter", vb);
	        } else {
	        	throw new IllegalStateException("Invalid formatter reference : " + formatter);
	        }
	    }		
	    if (upperMargin != null) {
	        if (isValueReference(upperMargin)) {
	            ValueBinding vb = Util.getValueBinding(upperMargin);
				chart.setValueBinding("upperMargin", vb);
	        } else {
				chart.setUpperMargin(upperMargin);
	        }
	    }		
	    if (labelAngle != null) {
	        if (isValueReference(labelAngle)) {
	            ValueBinding vb = Util.getValueBinding(labelAngle);
				chart.setValueBinding("labelAngle", vb);
	        } else {
				chart.setLabelAngle(labelAngle);
	        }
	    }		
	    if (includeZero != null) {
	        if (isValueReference(includeZero)) {
	            ValueBinding vb = Util.getValueBinding(includeZero);
				chart.setValueBinding("includeZero", vb);
	        } else {
				chart.setIncludeZero(includeZero);
	        }
	    }		
	    if (labelVisibility != null) {
	        if (isValueReference(labelVisibility)) {
	            ValueBinding vb = Util.getValueBinding(labelVisibility);
				chart.setValueBinding("labelVisibility", vb);
	        } else {
				chart.setLabelVisibility(labelVisibility);
	        }
	    }		
	    if (basicStroke != null) {
	        if (isValueReference(basicStroke)) {
	            ValueBinding vb = Util.getValueBinding(basicStroke);
				chart.setValueBinding("basicStroke", vb);
	        } else {
	        	throw new IllegalStateException("Invalid basicStroke reference : " + basicStroke);
	        }
	    }		
	    if (includeLegend != null) {
	        if (isValueReference(includeLegend)) {
	            ValueBinding vb = Util.getValueBinding(includeLegend);
				chart.setValueBinding("includeLegend", vb);
	        } else {
				chart.setIncludeLegend(includeLegend);
	        }
	    }		
	    if (includeTooltips != null) {
	        if (isValueReference(includeTooltips)) {
	            ValueBinding vb = Util.getValueBinding(includeTooltips);
				chart.setValueBinding("includeTooltips", vb);
	        } else {
				chart.setIncludeTooltips(includeTooltips);
	        }
	    }		
	    if (includeUrls != null) {
	        if (isValueReference(includeUrls)) {
	            ValueBinding vb = Util.getValueBinding(includeUrls);
				chart.setValueBinding("includeUrls", vb);
	        } else {
				chart.setIncludeUrls(includeUrls);
	        }
	    }		
	    if (orientation != null) {
	        if (isValueReference(orientation)) {
	            ValueBinding vb = Util.getValueBinding(orientation);
				chart.setValueBinding("orientation", vb);
	        } else {
	        	throw new IllegalStateException("Invalid orientation reference : " + orientation);
	        }
	    }
	    if (type != null) {
	        if (isValueReference(type)) {
	            ValueBinding vb = Util.getValueBinding(type);
				chart.setValueBinding("type", vb);
	        } else {
				chart.setType(type);
	        }
	    }
	    if (xAxisOrientation != null) {
	        if (isValueReference(xAxisOrientation)) {
	            ValueBinding vb = Util.getValueBinding(xAxisOrientation);
				chart.setValueBinding("xAxisOrientation", vb);
	        } else {
				chart.setXAxisOrientation(xAxisOrientation);
	        }
	    }
	    if (tickUnit != null) {
	        if (isValueReference(tickUnit)) {
	            ValueBinding vb = Util.getValueBinding(tickUnit);
				chart.setValueBinding("tickUnit", vb);
	        } else {
				chart.setTickUnit(tickUnit);
	        }
	    }	    
	}
	public void setBasicStroke(String basicStroke) {
		this.basicStroke = basicStroke;
	}
	public void setDataset(String dataset) {
		this.dataset = dataset;
	}
	public void setFormatter(String formatter) {
		this.formatter = formatter;
	}
	public void setIncludeLegend(String includeLegend) {
		this.includeLegend = includeLegend;
	}
	public void setIncludeTooltips(String includeTooltips) {
		this.includeTooltips = includeTooltips;
	}
	public void setIncludeUrls(String includeUrls) {
		this.includeUrls = includeUrls;
	}
	public void setIncludeZero(String includeZero) {
		this.includeZero = includeZero;
	}
	public void setLabelAngle(String labelAngle) {
		this.labelAngle = labelAngle;
	}
	public void setLabelVisibility(String labelVisibility) {
		this.labelVisibility = labelVisibility;
	}
	public void setOrientation(String orientation) {
		this.orientation = orientation;
	}
	public void setUpperMargin(String upperMargin) {
		this.upperMargin = upperMargin;
	}
	public void setAxisXLabel(String axisLabel) {
		axisXLabel = axisLabel;
	}
	public void setAxisYLabel(String axisYLabel) {
		this.axisYLabel = axisYLabel;
	}
	public void setType(String type) {
		this.type = type;
	}
	public void setXAxisOrientation(String axisOrientation) {
		xAxisOrientation = axisOrientation;
	}
	public void setTickUnit(String tickUnit) {
		this.tickUnit = tickUnit;
	}		

}
