/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.chart.taglib;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;

import org.jenia.faces.chart.component.html.HtmlPieChart3D;
import org.jenia.faces.util.Util;

public class PieChart3DTag extends ChartTag {
	
	private String pieDataSet;
	private String crush;
	
	public String getComponentType() {
		return HtmlPieChart3D.COMPONENT_TYPE;
	}
	public String getRendererType() {
		return HtmlPieChart3D.RENDERER_TYPE;
	}

	public void setPieDataSet(String pieDataSet) {
		this.pieDataSet = pieDataSet;
	}
	public void setCrush(String crush) {
		this.crush = crush;
	}	
	
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        HtmlPieChart3D chart = null;
        try {
			chart = (HtmlPieChart3D)component;
        }
        catch (ClassCastException cce) {
          throw new IllegalStateException("Component " + component.toString() + " not expected type.  Expected: UIPanel.  Perhaps you're missing a tag?");
        }
        if (pieDataSet != null) {
            if (isValueReference(pieDataSet)) {
                ValueBinding vb = Util.getValueBinding(pieDataSet);
				chart.setValueBinding("pieDataSet", vb);
            } else {
				throw new IllegalStateException("Invalid pieDataSet reference." + pieDataSet);
            }
        }
        if (crush != null) {
            if (isValueReference(crush)) {
                ValueBinding vb = Util.getValueBinding(crush);
				chart.setValueBinding("crush", vb);
            } else {
				chart.setCrush(crush);
            }
        }        
    }

}
