/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.facelets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.el.MethodExpression;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyMethodBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;

/**
 * Thanks to Maulin Shah for this code.
 * Basic implementation for facelets.
 * 
 * @author TessaroA
 *
 */
public class ActionRule extends MetaRule {
	
	public static ActionRule myself;;
	
	public static ActionRule getInstance() {
		if (myself!=null) return myself;
		synchronized (ActionRule.class) {
			if (myself!=null) return myself;
			myself=new ActionRule();
			return myself;
		}
	}

	private static class ActionPropertyMetadata extends Metadata {

		private final Method _method;

		private final TagAttribute _attribute;

		private Class[] _paramList;

		public ActionPropertyMetadata(Method method, TagAttribute attribute, Class[] paramList) {
			_method = method;
			_attribute = attribute;
			_paramList = paramList;
		}

		public void applyMetadata(FaceletContext ctx, Object instance) {
			MethodExpression expr = _attribute.getMethodExpression(ctx,	String.class, _paramList);
			try {
				_method.invoke(instance,new Object[] { new LegacyMethodBinding(expr) });
			} catch (InvocationTargetException e) {
				throw new TagAttributeException(_attribute, e.getCause());
			} catch (Exception e) {
				throw new TagAttributeException(_attribute, e);
			}
		}
	}

	public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
		if (name.startsWith("action")) {
			Method m = meta.getWriteMethod(name);
			if (m != null) {
				return new ActionPropertyMetadata(m, attribute, new Class[] {});
			}
		}
		return null;
	}
}
