/*
 * Copyright 2005 Jenia org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jenia.faces.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jenia.faces.chart.util.ChartBean;

/**
 * @author TessaroA
 *
 */
public class Servlet extends HttpServlet {
	
	private static final Date modify = new Date(System.currentTimeMillis());
	
	private static final SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

	private static Logger logger = Logger.getLogger(Servlet.class.getName());
	
	private static final long serialVersionUID = 3977576987609019191L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

		if (request.getPathInfo().startsWith("/chart")) {
			preventCaching(request, response);
			String chartName = request.getPathInfo().substring(6);
			String fileExt = request.getPathInfo().substring(request.getPathInfo().length()-3,request.getPathInfo().length());
			
			if (fileExt.equals("png")) {
				
				ChartBean chartBean = (ChartBean)request.getSession().getAttribute(chartName);
				if (chartBean == null)
					throw new ServletException("Chart bean: "+chartName+" not found");
	
				chartBean.writeChart(response.getOutputStream());
			}  else if (fileExt.equals("jpg"))	{	
				ChartBean chartBean = (ChartBean)request.getSession().getAttribute(chartName);
				if (chartBean == null)
					throw new ServletException("Chart bean: "+chartName+" not found");
	
				chartBean.writeChartJPEG(response.getOutputStream());	
				
			} else if (fileExt.equals("svg"))	{	
				ChartBean chartBean = (ChartBean)request.getSession().getAttribute(chartName);
				
				if (chartBean == null)
					throw new ServletException("Chart bean: "+chartName+" not found");

				try {
					chartBean.saveChartToSVG(response.getWriter());
				} catch (Throwable e) {
					e.printStackTrace();
					throw new ServletException("Chart bean: "+chartName+" : error displaying",e);
				}	
			}
			
			return;
		}
		
        // search the resource in classloader
        ClassLoader cl = this.getClass().getClassLoader();
        String uri = request.getRequestURI();

        if (uri.endsWith(".jsf")) {
        	response.setContentType("text/html;");
        } else {
            response.setHeader("Cache-Control", "public");
            response.setHeader("Last-Modified", sdf.format(modify));
        }
        if (uri.endsWith(".css")) {
        	response.setContentType("text/css;");
        } else if (uri.endsWith(".js")) {
        	response.setContentType("text/js;");
        } else if (uri.endsWith(".gif")) {
        	response.setContentType("image/gif;");
        }
        String path = uri.substring(uri.indexOf(Util.JENIA_RESOURCE_PREFIX)+Util.JENIA_RESOURCE_PREFIX.length()+1);
        InputStream is = cl.getResourceAsStream(path);
        // if no resource found in classloader return nothing
        if (is==null) return;
        // resource found, copying on output stream
        OutputStream out = response.getOutputStream();
        byte[] buffer = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is);
        int read = 0;
        read = bis.read(buffer);
        while (read!=-1) {
            out.write(buffer,0,read);
            read = bis.read(buffer);
        }
        bis.close();
        out.flush();
        out.close();
    }

	/**
	 * thanks to Ferret Renaud for this code
	 * @param request
	 * @param response
	 */
	private void preventCaching(HttpServletRequest request,
			HttpServletResponse response) {
		// see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html
		String protocol = request.getProtocol();
		if ("HTTP/1.0".equalsIgnoreCase(protocol)) {
			response.setHeader("Pragma", "no-cache");
		} else if ("HTTP/1.1".equalsIgnoreCase(protocol)) {
			response.setHeader("Cache-Control", "no-cache"); // "no-store"
			// work also
		}
		response.setDateHeader("Expires", 0);
	}	
}
