/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.autodetector.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.seasar.framework.autodetector.ResourceAutoDetector;
import org.seasar.framework.autodetector.impl.AbstractAutoDetector;
import org.seasar.framework.traverser.ResourceTraverser;
import org.seasar.framework.util.ResourceTraversal;

public class ResourceAutoDetectorImpl
extends AbstractAutoDetector
implements ResourceAutoDetector {
    public static final String INIT_METHOD = "initialize";
    private static final String ROOT = "";
    private final List resourceNamePatterns = new ArrayList();
    private final List ignoreResourceNamePatterns = new ArrayList();

    public void addResourceNamePattern(String resourceName) {
        this.resourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public void addIgnoreResourceNamePattern(String resourceName) {
        this.ignoreResourceNamePatterns.add(Pattern.compile(resourceName));
    }

    public Pattern getResourceNamePattern(int index) {
        return (Pattern)this.resourceNamePatterns.get(index);
    }

    public int getResourceNamePatternSize() {
        return this.resourceNamePatterns.size();
    }

    public Pattern getIgnoreResourceNamePattern(int index) {
        return (Pattern)this.ignoreResourceNamePatterns.get(index);
    }

    public int getIgnoreResourceNamePatternSize() {
        return this.ignoreResourceNamePatterns.size();
    }

    public void initialize() {
        if (this.getDirectoryNameSize() == 0) {
            this.addDirectoryName(ROOT);
        }
    }

    public ResourceAutoDetector.Entry[] detect(String path, URL url) {
        final ArrayList result = new ArrayList();
        AbstractAutoDetector.Strategy strategy = this.getStrategy(url.getProtocol());
        ResourceTraverser traverser = new ResourceTraverser(new ResourceTraversal.ResourceHandler(){

            public void processResource(String path, InputStream is) {
                if (ResourceAutoDetectorImpl.this.isApplied(path) && !ResourceAutoDetectorImpl.this.isIgnored(path)) {
                    Entry entry = new Entry(path, is);
                    result.add(entry);
                }
            }
        });
        strategy.detect(path, url, traverser);
        return result.toArray(new Entry[result.size()]);
    }

    protected boolean isApplied(String resourceName) {
        for (int i = 0; i < this.getResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnored(String resourceName) {
        for (int i = 0; i < this.getIgnoreResourceNamePatternSize(); ++i) {
            Pattern pattern = this.getIgnoreResourceNamePattern(i);
            if (!pattern.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }

    public static class Entry
    implements ResourceAutoDetector.Entry {
        private String path;
        private InputStream is;

        Entry(String path, InputStream is) {
            this.path = path;
            this.is = is;
        }

        public String getPath() {
            return this.path;
        }

        public InputStream getInputStream() {
            return this.is;
        }
    }
}

