/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import java.io.File;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.seasar.framework.container.autoregister.AbstractComponentAutoRegister;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractJarComponentAutoRegister
extends AbstractComponentAutoRegister {
    private String baseDir;
    private Pattern[] jarFileNamePatterns;

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void registerAll() {
        if (this.baseDir == null) {
            this.setupBaseDir();
        }
        File dir = new File(this.baseDir);
        String[] jars = dir.list();
        for (int i = 0; i < jars.length; ++i) {
            if (!this.isAppliedJar(jars[i])) continue;
            JarFile jarFile = JarFileUtil.create(this.findJar(jars[i]));
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)this);
        }
    }

    protected abstract void setupBaseDir();

    protected boolean isAppliedJar(String jarFileName) {
        if (this.jarFileNamePatterns == null) {
            return true;
        }
        String extention = ResourceUtil.getExtension(jarFileName);
        if (extention == null || !extention.equalsIgnoreCase("jar")) {
            return false;
        }
        String name = ResourceUtil.removeExtension(jarFileName);
        for (int i = 0; i < this.jarFileNamePatterns.length; ++i) {
            if (!this.jarFileNamePatterns[i].matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    protected File findJar(String jarFileName) {
        return new File(this.baseDir, jarFileName);
    }

    public void setJarFileNames(String jarFileNames) {
        String[] array = StringUtil.split(jarFileNames, ",");
        this.jarFileNamePatterns = new Pattern[array.length];
        for (int i = 0; i < array.length; ++i) {
            String s = array[i].trim();
            this.jarFileNamePatterns[i] = Pattern.compile(s);
        }
    }
}

