/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external;

import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.deployer.ExternalComponentDeployerProvider;
import org.seasar.framework.container.external.GenericExternalContext;
import org.seasar.framework.container.external.GenericExternalContextComponentDefRegister;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class GenericS2ContainerInitializer {
    protected String containerConfigPath;
    protected String configPath;
    protected ExternalContext externalContext;
    protected ExternalContextComponentDefRegister externalContextComponentDefRegister;

    public GenericS2ContainerInitializer() {
        this(new GenericExternalContext(), new GenericExternalContextComponentDefRegister());
    }

    public GenericS2ContainerInitializer(ExternalContext externalContext, ExternalContextComponentDefRegister externalContextComponentDefRegister) {
        this.externalContext = externalContext;
        this.externalContextComponentDefRegister = externalContextComponentDefRegister;
    }

    public S2Container initialize() {
        if (this.isAlreadyInitialized()) {
            return SingletonS2ContainerFactory.getContainer();
        }
        if (!StringUtil.isEmpty(this.containerConfigPath)) {
            S2ContainerFactory.configure(this.configPath);
        }
        if (!StringUtil.isEmpty(this.configPath)) {
            SingletonS2ContainerFactory.setConfigPath(this.configPath);
        }
        if (ComponentDeployerFactory.getProvider() instanceof ComponentDeployerFactory.DefaultProvider) {
            ComponentDeployerFactory.setProvider(new ExternalComponentDeployerProvider());
        }
        SingletonS2ContainerFactory.setExternalContext(this.externalContext);
        SingletonS2ContainerFactory.setExternalContextComponentDefRegister(this.externalContextComponentDefRegister);
        SingletonS2ContainerFactory.init();
        return SingletonS2ContainerFactory.getContainer();
    }

    protected boolean isAlreadyInitialized() {
        return SingletonS2ContainerFactory.hasContainer();
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }
}

