/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.creator;

import java.util.ArrayList;
import java.util.List;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.hotdeploy.creator.AbstractOndemandCreator;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class MultiPackageOndemandCreator
extends AbstractOndemandCreator {
    private List middlePackageNames = new ArrayList();

    public MultiPackageOndemandCreator(NamingConvention namingConvention) {
        super(namingConvention);
    }

    public String[] getPackageNames(String rootPackageName) {
        String[] names = new String[this.middlePackageNames.size()];
        for (int i = 0; i < this.middlePackageNames.size(); ++i) {
            names[i] = ClassUtil.concatName(rootPackageName, (String)this.middlePackageNames.get(i));
        }
        return names;
    }

    public void addMiddlePackageName(String middlePackageName) {
        this.middlePackageNames.add(middlePackageName);
    }

    protected String[] composeClassNames(String rootPackageName, String componentName) {
        String[] names = StringUtil.split(componentName, "_");
        String shortClassName = StringUtil.capitalize(names[names.length - 1]);
        String[] pNames = this.getPackageNames(rootPackageName);
        String[] classNames = new String[pNames.length];
        for (int i = 0; i < pNames.length; ++i) {
            StringBuffer sb = new StringBuffer(100);
            this.concatName(sb, pNames[i]);
            for (int j = 0; j < names.length - 1; ++j) {
                this.concatName(sb, names[j]);
            }
            this.concatName(sb, shortClassName);
            classNames[i] = sb.toString();
        }
        return classNames;
    }

    protected boolean isTargetMiddlePackage(String rootPackageName, String className) {
        String[] pNames = this.getPackageNames(rootPackageName);
        if (pNames.length == 0) {
            return true;
        }
        for (int i = 0; i < pNames.length; ++i) {
            if (!className.startsWith(pNames[i])) continue;
            return true;
        }
        return false;
    }

    protected Class getTargetClass(String rootPackageName, String componentName) {
        String[] classNames = this.composeClassNames(rootPackageName, componentName);
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            String path = ClassUtil.getResourcePath(className);
            if (ResourceUtil.getResourceAsFileNoException(path) == null) continue;
            return ClassUtil.forName(className);
        }
        throw new ComponentNotFoundRuntimeException((Object)componentName);
    }
}

