/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.deployer.ExternalComponentDeployerProvider;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.external.servlet.HttpServletExternalContextComponentDefRegister;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.env.Env;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServletConfig;
import org.seasar.framework.mock.servlet.MockServletConfigImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.unit.UnitClassLoader;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public abstract class S2FrameworkTestCase
extends TestCase {
    private S2Container container;
    private Servlet servlet;
    private MockServletConfig servletConfig;
    private MockServletContext servletContext;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private ClassLoader originalClassLoader;
    private UnitClassLoader unitClassLoader;
    private NamingConvention namingConvention;
    static /* synthetic */ Class class$org$seasar$framework$unit$S2FrameworkTestCase;

    public S2FrameworkTestCase() {
    }

    public S2FrameworkTestCase(String name) {
        super(name);
    }

    public S2Container getContainer() {
        return this.container;
    }

    public Object getComponent(String componentName) {
        return this.container.getComponent(componentName);
    }

    public Object getComponent(Class componentClass) {
        return this.container.getComponent(componentClass);
    }

    public ComponentDef getComponentDef(String componentName) {
        return this.container.getComponentDef(componentName);
    }

    public ComponentDef getComponentDef(Class componentClass) {
        return this.container.getComponentDef(componentClass);
    }

    public void register(Class componentClass) {
        this.container.register(componentClass, this.namingConvention.fromClassNameToComponentName(componentClass.getName()));
    }

    public void register(Class componentClass, String componentName) {
        this.container.register(componentClass, componentName);
    }

    public void register(Object component) {
        this.container.register(component);
    }

    public void register(Object component, String componentName) {
        this.container.register(component, componentName);
    }

    public void register(ComponentDef componentDef) {
        this.container.register(componentDef);
    }

    public void include(String path) {
        S2ContainerFactory.include(this.container, this.convertPath(path));
    }

    protected String convertPath(String path) {
        if (ResourceUtil.getResourceNoException(path) != null) {
            return path;
        }
        String prefix = ((Object)((Object)this)).getClass().getName().replace('.', '/').replaceFirst("/[^/]+$", "");
        return prefix + "/" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUpContainer();
        this.setUp();
        try {
            this.setUpForEachTestMethod();
            try {
                this.container.init();
                try {
                    this.setUpAfterContainerInit();
                    try {
                        this.bindFields();
                        this.setUpAfterBindFields();
                        try {
                            this.doRunTest();
                        }
                        finally {
                            this.tearDownBeforeUnbindFields();
                            this.unbindFields();
                        }
                    }
                    finally {
                        this.tearDownBeforeContainerDestroy();
                    }
                }
                finally {
                    this.container.destroy();
                }
            }
            finally {
                this.tearDownForEachTestMethod();
            }
        }
        finally {
            this.tearDown();
            this.tearDownContainer();
        }
    }

    protected void setUpContainer() throws Throwable {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.unitClassLoader = new UnitClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.unitClassLoader);
        this.container = new S2ContainerImpl();
        SingletonS2ContainerFactory.setContainer(this.container);
        if (this.servletContext == null) {
            this.servletContext = new MockServletContextImpl("s2-example");
        }
        this.request = this.servletContext.createRequest("/hello.html");
        this.response = new MockHttpServletResponseImpl(this.request);
        this.servletConfig = new MockServletConfigImpl();
        this.servletConfig.setServletContext(this.servletContext);
        this.servlet = new S2ContainerServlet();
        this.servlet.init((ServletConfig)this.servletConfig);
        HttpServletExternalContext externalContext = new HttpServletExternalContext();
        externalContext.setApplication(this.servletContext);
        externalContext.setRequest(this.request);
        externalContext.setResponse(this.response);
        this.container.setExternalContext(externalContext);
        this.container.setExternalContextComponentDefRegister(new HttpServletExternalContextComponentDefRegister());
        ComponentDeployerFactory.setProvider(new ExternalComponentDeployerProvider());
        this.namingConvention = new NamingConventionImpl();
        this.container.register(this.namingConvention);
    }

    protected void tearDownContainer() throws Throwable {
        ComponentDeployerFactory.setProvider(new ComponentDeployerFactory.DefaultProvider());
        SingletonS2ContainerFactory.setContainer(null);
        S2ContainerServlet.clearInstance();
        DisposableUtil.dispose();
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.unitClassLoader = null;
        this.originalClassLoader = null;
        this.container = null;
        this.servletContext = null;
        this.request = null;
        this.response = null;
        this.servletConfig = null;
        this.servlet = null;
        this.namingConvention = null;
        Env.initialize();
    }

    protected void setUpAfterContainerInit() throws Throwable {
    }

    protected void setUpAfterBindFields() throws Throwable {
    }

    protected void tearDownBeforeUnbindFields() throws Throwable {
    }

    protected void setUpForEachTestMethod() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("setUp" + targetName);
        }
    }

    protected void tearDownBeforeContainerDestroy() throws Throwable {
    }

    protected void tearDownForEachTestMethod() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("tearDown" + this.getTargetName());
        }
    }

    protected void doRunTest() throws Throwable {
        this.runTest();
    }

    protected Servlet getServlet() {
        return this.servlet;
    }

    protected void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    protected MockServletConfig getServletConfig() {
        return this.servletConfig;
    }

    protected void setServletConfig(MockServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    protected MockServletContext getServletContext() {
        return this.servletContext;
    }

    protected void setServletContext(MockServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected MockHttpServletRequest getRequest() {
        return this.request;
    }

    protected void setRequest(MockHttpServletRequest request) {
        this.request = request;
    }

    protected MockHttpServletResponse getResponse() {
        return this.response;
    }

    protected void setResponse(MockHttpServletResponse response) {
        this.response = response;
    }

    protected NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    protected String getTargetName() {
        return this.getName().substring(4);
    }

    protected void invoke(String methodName) throws Throwable {
        try {
            Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), methodName, null);
            MethodUtil.invoke(method, (Object)this, null);
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            // empty catch block
        }
    }

    protected void bindFields() throws Throwable {
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != (class$org$seasar$framework$unit$S2FrameworkTestCase == null ? S2FrameworkTestCase.class$("org.seasar.framework.unit.S2FrameworkTestCase") : class$org$seasar$framework$unit$S2FrameworkTestCase) && clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.bindField(fields[i]);
            }
        }
    }

    protected void bindField(Field field) {
        if (this.isAutoBindable(field)) {
            field.setAccessible(true);
            if (FieldUtil.get(field, (Object)this) != null) {
                return;
            }
            String name = this.normalizeName(field.getName());
            Object component = null;
            if (this.getContainer().hasComponentDef(name)) {
                Class<?> componentClass = this.getComponentDef(name).getComponentClass();
                if (componentClass == null && (component = this.getComponent(name)) != null) {
                    componentClass = component.getClass();
                }
                if (componentClass != null && field.getType().isAssignableFrom(componentClass)) {
                    if (component == null) {
                        component = this.getComponent(name);
                    }
                } else {
                    component = null;
                }
            }
            if (component == null && this.getContainer().hasComponentDef(field.getType())) {
                component = this.getComponent(field.getType());
            }
            if (component != null) {
                FieldUtil.set(field, (Object)this, component);
            }
        }
    }

    protected String normalizeName(String name) {
        return StringUtil.replace(name, "_", "");
    }

    protected boolean isAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    protected void unbindFields() {
    }
}

