/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.OgnlRuntimeException;

public final class OgnlUtil {
    private OgnlUtil() {
    }

    public static Object getValue(Object exp, Object root) {
        return OgnlUtil.getValue(exp, root, null, 0);
    }

    public static Object getValue(Object exp, Object root, String path, int lineNumber) {
        return OgnlUtil.getValue(exp, null, root, path, lineNumber);
    }

    public static Object getValue(Object exp, Map ctx, Object root) {
        return OgnlUtil.getValue(exp, ctx, root, null, 0);
    }

    public static Object getValue(Object exp, Map ctx, Object root, String path, int lineNumber) {
        try {
            Map newCtx = OgnlUtil.addClassResolverIfNecessary(ctx, root);
            if (newCtx != null) {
                return Ognl.getValue((Object)exp, (Map)newCtx, (Object)root);
            }
            return Ognl.getValue((Object)exp, (Object)root);
        }
        catch (Exception ex) {
            throw new OgnlRuntimeException(ex, path, lineNumber);
        }
    }

    public static Object parseExpression(String expression) {
        return OgnlUtil.parseExpression(expression, null, 0);
    }

    public static Object parseExpression(String expression, String path, int lineNumber) {
        try {
            return Ognl.parseExpression((String)expression);
        }
        catch (Exception ex) {
            throw new OgnlRuntimeException(ex, path, lineNumber);
        }
    }

    static Map addClassResolverIfNecessary(Map ctx, Object root) {
        S2Container container;
        ClassLoader classLoader;
        if (root instanceof S2Container && (classLoader = (container = (S2Container)root).getClassLoader()) != null) {
            ClassResolverImpl classResolver = new ClassResolverImpl(classLoader);
            ctx = ctx == null ? Ognl.createDefaultContext((Object)root, (ClassResolver)classResolver) : Ognl.addDefaultContext((Object)root, (ClassResolver)classResolver, (Map)ctx);
        }
        return ctx;
    }

    public static class ClassResolverImpl
    implements ClassResolver {
        private ClassLoader classLoader_;

        public ClassResolverImpl(ClassLoader classLoader) {
            this.classLoader_ = classLoader;
        }

        public Class classForName(String className, Map ctx) throws ClassNotFoundException {
            try {
                return Class.forName(className, true, this.classLoader_);
            }
            catch (ClassNotFoundException ex) {
                int dot = className.indexOf(46);
                if (dot < 0) {
                    return Class.forName("java.lang." + className, true, this.classLoader_);
                }
                throw ex;
            }
        }
    }
}

