/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class MyFacesResourceLoader
implements ResourceLoader {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader == null ? (class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader = MyFacesResourceLoader.class$("org.apache.myfaces.renderkit.html.util.MyFacesResourceLoader")) : class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader));
    static final String ORG_APACHE_MYFACES_CUSTOM = "org.apache.myfaces.custom";
    private static long lastModified = 0L;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$MyFacesResourceLoader;
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$util$AddResource;

    private static long getLastModified() {
        if (lastModified == 0L) {
            String format = "yyyy-MM-dd HH:mm:ss Z";
            String bundleName = (class$org$apache$myfaces$renderkit$html$util$AddResource == null ? (class$org$apache$myfaces$renderkit$html$util$AddResource = MyFacesResourceLoader.class$("org.apache.myfaces.renderkit.html.util.AddResource")) : class$org$apache$myfaces$renderkit$html$util$AddResource).getName();
            ResourceBundle resources = ResourceBundle.getBundle(bundleName);
            String sLastModified = resources.getString("lastModified");
            try {
                lastModified = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(sLastModified).getTime();
            }
            catch (ParseException e) {
                lastModified = new Date().getTime();
                log.error((Object)("Unparsable lastModified : " + sLastModified));
            }
        }
        return lastModified;
    }

    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        Class componentClass;
        String[] uriParts = resourceUri.split("/", 2);
        String component = uriParts[0];
        if (component == null || component.trim().length() == 0) {
            response.sendError(400, "Invalid request");
            log.error((Object)"Could not find parameter for component to load a resource.");
            return;
        }
        String className = "org.apache.myfaces.custom." + component;
        try {
            componentClass = this.loadComponentClass(className);
        }
        catch (ClassNotFoundException e) {
            response.sendError(400, e.getMessage());
            log.error((Object)("Could not find the class for component " + className + " to load a resource."));
            return;
        }
        String resource = uriParts[1];
        if (resource == null || resource.trim().length() == 0) {
            response.sendError(400, "No resource defined");
            log.error((Object)("No resource defined component class " + className));
            return;
        }
        resource = "resource/" + resource;
        InputStream is = componentClass.getResourceAsStream(resource);
        if (is == null) {
            response.sendError(404, "Unable to find resource " + resource + " for component " + component + ". Check that this file is available " + "in the classpath in sub-directory " + "/resource of the package-directory.");
            log.error((Object)("Unable to find resource " + resource + " for component " + component + ". Check that this file is available " + "in the classpath in sub-directory " + "/resource of the package-directory."));
        } else {
            this.defineContentHeaders(request, response, resource);
            this.defineCaching(request, response, resource);
            this.writeResource(request, response, is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResource(HttpServletRequest request, HttpServletResponse response, InputStream in) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int size = in.read(buffer);
            while (size != -1) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            out.close();
        }
    }

    protected void defineCaching(HttpServletRequest request, HttpServletResponse response, String resource) {
        response.setDateHeader("Last-Modified", MyFacesResourceLoader.getLastModified());
        Calendar expires = Calendar.getInstance();
        expires.add(6, 7);
        response.setDateHeader("Expires", expires.getTimeInMillis());
    }

    protected void defineContentHeaders(HttpServletRequest request, HttpServletResponse response, String resource) {
        if (resource.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (resource.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (resource.endsWith(".jpg") || resource.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (resource.endsWith(".xml") || resource.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
    }

    protected Class loadComponentClass(String componentClass) throws ClassNotFoundException {
        return ClassUtils.classForName(componentClass);
    }

    protected void validateCustomComponent(Class myfacesCustomComponent) {
        if (!myfacesCustomComponent.getName().startsWith("org.apache.myfaces.custom.")) {
            throw new IllegalArgumentException("expected a myfaces custom component class in package org.apache.myfaces.custom");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

