/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import org.seasar.framework.util.AssertionUtil;

public class ComponentChildrenListWrapper
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = 3617294519188666163L;
    private List list = new ArrayList();
    private UIComponent parent = null;

    public ComponentChildrenListWrapper(UIComponent parent) {
        this.parent = parent;
    }

    public Object get(int num) {
        return this.list.get(num);
    }

    public Object remove(int num) {
        UIComponent child = (UIComponent)this.list.remove(num);
        if (child != null) {
            child.setParent(null);
        }
        return child;
    }

    public int size() {
        return this.list.size();
    }

    public void add(int num, Object obj) {
        ComponentChildrenListWrapper.assertUIComponent(obj);
        this.setNewParent((UIComponent)obj);
        this.list.add(num, obj);
    }

    public boolean add(Object obj) {
        ComponentChildrenListWrapper.assertUIComponent(obj);
        this.setNewParent((UIComponent)obj);
        return this.list.add(obj);
    }

    public boolean addAll(Collection collection) {
        boolean changed = false;
        Object obj = null;
        Iterator itr = collection.iterator();
        while (itr.hasNext()) {
            obj = itr.next();
            ComponentChildrenListWrapper.assertUIComponent(obj);
            this.add((Object)obj);
            changed = true;
        }
        return changed;
    }

    private void setNewParent(UIComponent child) {
        UIComponent oldParent = child.getParent();
        if (oldParent != null) {
            this.removeFromParent(oldParent, child);
        }
        child.setParent(this.parent);
    }

    private void removeFromParent(UIComponent parent, UIComponent child) {
        parent.getChildren().remove(child);
    }

    private static void assertUIComponent(Object obj) {
        AssertionUtil.assertNotNull((String)"value", (Object)obj);
        if (!(obj instanceof UIComponent)) {
            throw new ClassCastException("value");
        }
    }
}

