/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.WebAppUtil;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class FacesServlet
implements Servlet {
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private ServletConfig config = null;
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;

    public void destroy() {
        this.config = null;
        this.facesContextFactory = null;
        this.lifecycle = null;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "Teeda - A JSF implementation with DI x AOP by Seasar Foundation -";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.facesContextFactory = (FacesContextFactory)WebAppUtil.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)WebAppUtil.getFactory("javax.faces.lifecycle.LifecycleFactory");
        String lifecycleId = WebAppUtil.getLifecycleId(config);
        this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.config.getServletContext();
        FacesContext context = this.facesContextFactory.getFacesContext(servletContext, request, response, this.lifecycle);
        try {
            this.lifecycle.execute(context);
            this.lifecycle.render(context);
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new ServletException(t.getMessage(), t);
        }
        finally {
            context.release();
        }
    }
}

