/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import org.seasar.teeda.core.application.TeedaStateManager;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.util.ResponseStateManagerUtil;

public class TeedaStateManagerImpl
extends TeedaStateManager
implements Serializable {
    static final long serialVersionUID = 0L;
    private Map serializedViews = new HashMap();

    public synchronized UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            viewRoot.setViewId(viewId);
            this.restoreComponentState(context, viewRoot, renderKitId);
        }
        return viewRoot;
    }

    public synchronized StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        UIViewRoot viewRoot = context.getViewRoot();
        if (this.isSavingStateInClient(context)) {
            return this.createSerializedView(context);
        }
        if (!this.hasSerializedViewInServer(viewRoot.getViewId())) {
            this.saveSerializedViewToServer(viewRoot.getViewId(), this.createSerializedView(context));
        }
        return null;
    }

    protected StateManager.SerializedView createSerializedView(FacesContext context) {
        Object struct = this.getTreeStructureToSave(context);
        Object state = this.getComponentStateToSave(context);
        return new StateManager.SerializedView(this, struct, state);
    }

    public synchronized void removeSerializedView(String viewId) {
        this.serializedViews.remove(viewId);
    }

    public synchronized void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        if (this.isSavingStateInClient(context)) {
            UIViewRoot viewRoot = context.getViewRoot();
            ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, viewRoot.getRenderKitId());
            responseStateManager.writeState(context, serializedView);
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.getTreeStructureManager().buildTreeStructure(viewRoot);
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (viewRoot.getRenderKitId() == null) {
            viewRoot.setRenderKitId(renderKitId);
        }
        if (this.isSavingStateInClient(context)) {
            this.restoreComponentStateFromClient(context, viewRoot, renderKitId);
        } else {
            this.restoreComponentStateFromServer(context, viewRoot);
        }
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (this.isSavingStateInClient(context)) {
            return this.restoreTreeStructureFromClient(context, viewId, renderKitId);
        }
        return this.restoreTreeStructureFromServer(context, viewId);
    }

    protected void restoreComponentStateFromClient(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, renderKitId);
        Object state = responseStateManager.getComponentStateToRestore(context);
        viewRoot.processRestoreState(context, state);
    }

    protected void restoreComponentStateFromServer(FacesContext context, UIViewRoot viewRoot) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(viewRoot.getViewId());
        if (serializedView == null) {
            return;
        }
        Object state = serializedView.getState();
        if (state == null) {
            return;
        }
        viewRoot.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructureFromClient(FacesContext context, String viewId, String renderKitId) {
        ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, renderKitId);
        TreeStructure struct = (TreeStructure)responseStateManager.getTreeStructureToRestore(context, viewId);
        if (struct == null) {
            return null;
        }
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    protected UIViewRoot restoreTreeStructureFromServer(FacesContext context, String viewId) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(viewId);
        if (serializedView == null) {
            return null;
        }
        TreeStructure struct = (TreeStructure)serializedView.getStructure();
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    private static void assertRenderKitIdNotNull(String renderKitId) {
        if (renderKitId == null) {
            throw new IllegalArgumentException();
        }
    }

    protected StateManager.SerializedView getSerializedViewFromServer(String viewId) {
        return (StateManager.SerializedView)this.serializedViews.get(viewId);
    }

    protected boolean hasSerializedViewInServer(String viewId) {
        return this.serializedViews.containsKey(viewId);
    }

    protected void saveSerializedViewToServer(String viewId, StateManager.SerializedView serializedView) {
        this.serializedViews.put(viewId, serializedView);
    }
}

