/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.teeda.core.config.faces.assembler.ManagedBeanAssembler;
import org.seasar.teeda.core.config.faces.element.ManagedBeanElement;
import org.seasar.teeda.core.exception.ManagedBeanDuplicateRegisterException;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.ScopeManager;
import org.seasar.teeda.core.util.ClassUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.IteratorUtil;

public class DefaultManagedBeanAssembler
extends ManagedBeanAssembler {
    private ManagedBeanFactory managedBeanFactory;
    private ScopeManager scopeManager;

    public DefaultManagedBeanAssembler(Map managedBeans) {
        super(managedBeans);
    }

    protected void setupBeforeAssemble() {
        this.managedBeanFactory = (ManagedBeanFactory)DIContainerUtil.getComponent(ManagedBeanFactory.class);
        this.scopeManager = (ScopeManager)DIContainerUtil.getComponent(ScopeManager.class);
    }

    public void assemble() {
        Iterator itr = IteratorUtil.getEntryIterator(this.getManagedBeans());
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            ManagedBeanElement element = (ManagedBeanElement)entry.getValue();
            String mbName = (String)entry.getKey();
            String mbClassName = element.getManagedBeanClass();
            String mbScope = element.getManagedBeanScope();
            this.assertNotRegisteredYet(mbName);
            Scope scope = this.getScopeManager().getScope(mbScope);
            Class clazz = ClassUtil.forName(mbClassName);
            ComponentDefImpl cDef = new ComponentDefImpl(clazz, mbName);
            this.registerManagedBean((ComponentDef)cDef, scope);
        }
    }

    protected void registerManagedBean(ComponentDef componentDef, Scope scope) {
        this.getManagedBeanFactory().registerManagedBean(componentDef, scope);
    }

    protected ManagedBeanFactory getManagedBeanFactory() {
        return this.managedBeanFactory;
    }

    protected ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    private void assertNotRegisteredYet(String managedBeanName) {
        Object managedBean = this.managedBeanFactory.getManagedBean(managedBeanName);
        if (managedBean != null) {
            throw new ManagedBeanDuplicateRegisterException(managedBeanName);
        }
    }
}

