/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.lifecycle.Phase;
import org.seasar.teeda.core.lifecycle.Postback;
import org.seasar.teeda.core.util.ServletExternalContextUtil;

public class LifecycleImpl
extends Lifecycle {
    private static final String EXECUTED_ATTR = LifecycleImpl.class.getName() + ".EXECUTED";
    private static final String REDIRECTED_TIME_ATTR = LifecycleImpl.class.getName() + ".REDIRECTED_TIME";
    private static final long REDIRECT_WAIT_TIME = 2000L;
    private PhaseListener[] phaseListeners = new PhaseListener[0];
    private Phase restoreViewPhase;
    private AbstractPhase applyRequestValuesPhase;
    private Phase invokeApplicationPhase;
    private Phase renderResponsePhase;
    private Phase processValidationPhase;
    private Phase updateModelValuesPhase;

    public void execute(FacesContext context) throws FacesException {
        try {
            Map requestMap;
            this.restoreViewPhase.execute(context);
            Postback postback = NullPostback.getCurrentInstance();
            if (this.restoreViewPhase instanceof Postback) {
                postback = (Postback)((Object)this.restoreViewPhase);
            }
            if (this.isFinished(context)) {
                return;
            }
            ExternalContext extContext = context.getExternalContext();
            Map sessionMap = extContext.getSessionMap();
            Long redirectedTime = (Long)sessionMap.get(REDIRECTED_TIME_ATTR);
            if (redirectedTime != null) {
                sessionMap.remove(REDIRECTED_TIME_ATTR);
                if (System.currentTimeMillis() - redirectedTime < 2000L) {
                    context.renderResponse();
                    return;
                }
            }
            if ((requestMap = extContext.getRequestMap()).containsKey(EXECUTED_ATTR)) {
                context.renderResponse();
                return;
            }
            requestMap.put(EXECUTED_ATTR, EXECUTED_ATTR);
            this.applyRequestValuesPhase.execute(context);
            if (this.isFinished(context)) {
                this.applyRequestValuesPhase.initializeChildren(context, context.getViewRoot());
                return;
            }
            if (postback.isPostBack() || this.hasEvent(context)) {
                this.processValidationPhase.execute(context);
                if (this.isFinished(context)) {
                    return;
                }
            }
            this.updateModelValuesPhase.execute(context);
            if (this.isFinished(context)) {
                return;
            }
            this.invokeApplicationPhase.execute(context);
            if (this.isGetRedirect(context)) {
                sessionMap.put(REDIRECTED_TIME_ATTR, new Long(System.currentTimeMillis()));
            }
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw ex;
        }
    }

    protected boolean isGetRedirect(FacesContext context) {
        if (!context.getResponseComplete()) {
            return false;
        }
        ExternalContext extContext = context.getExternalContext();
        return ServletExternalContextUtil.isGetRedirect(extContext);
    }

    public void render(FacesContext context) throws FacesException {
        if (context.getResponseComplete()) {
            return;
        }
        this.renderResponsePhase.execute(context);
    }

    protected boolean isFinished(FacesContext context) throws FacesException {
        return context.getResponseComplete() || context.getRenderResponse();
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.add((Object[])this.phaseListeners, (Object)listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.remove((Object[])this.phaseListeners, (Object)listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.phaseListeners;
    }

    protected boolean hasEvent(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot.getEventSize() > 0;
    }

    public void setRestoreViewPhase(Phase restoreViewPhase) {
        this.restoreViewPhase = restoreViewPhase;
    }

    public void setApplyRequestValuesPhase(AbstractPhase applyRequestValuesPhase) {
        this.applyRequestValuesPhase = applyRequestValuesPhase;
    }

    public void setInvokeApplicationPhase(Phase invokeApplicationPhase) {
        this.invokeApplicationPhase = invokeApplicationPhase;
    }

    public void setRenderResponsePhase(Phase renderPhase) {
        this.renderResponsePhase = renderPhase;
    }

    public void setProcessValidationsPhase(Phase processValidationPhase) {
        this.processValidationPhase = processValidationPhase;
    }

    public void setUpdateModelValuesPhase(Phase updateModelValuesPhase) {
        this.updateModelValuesPhase = updateModelValuesPhase;
    }

    public AbstractPhase getApplyRequestValuesPhase() {
        return this.applyRequestValuesPhase;
    }

    public Phase getInvokeApplicationPhase() {
        return this.invokeApplicationPhase;
    }

    public Phase getProcessValidationPhase() {
        return this.processValidationPhase;
    }

    public Phase getRenderResponsePhase() {
        return this.renderResponsePhase;
    }

    public Phase getRestoreViewPhase() {
        return this.restoreViewPhase;
    }

    public Phase getUpdateModelValuesPhase() {
        return this.updateModelValuesPhase;
    }

    private static final class NullPostback
    implements Postback {
        private static final NullPostback instance = new NullPostback();

        private NullPostback() {
        }

        public static NullPostback getCurrentInstance() {
            return instance;
        }

        public boolean isPostBack() {
            return false;
        }
    }
}

