/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.autoregister;

import java.lang.reflect.Field;
import javax.faces.internal.ModifierUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.autoregister.JarComponentAutoRegister;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.render.html.support.HtmlRenderKitKeyGenerateUtil;

public class TeedaRendererJarComponentAutoRegister
extends JarComponentAutoRegister {
    private String familyFieldName = "COMPONENT_FAMILY";
    private String renderTypeFieldName = "RENDERER_TYPE";

    protected void register(String className) {
        AnnotationHandler annoHandler;
        ComponentDef cd;
        Class componentClass;
        if (ClassUtil.isAssignableFrom((Class)Renderer.class, (Class)(componentClass = (cd = (annoHandler = AnnotationHandlerFactory.getAnnotationHandler()).createComponentDef(className, this.getInstanceDef(), this.getAutoBindingDef(), this.isExternalBinding())).getComponentClass()))) {
            String family = this.getConstantValue(componentClass, this.getFamilyFieldName());
            String renderType = this.getConstantValue(componentClass, this.getRenderTypeFieldName());
            String rendererComponentName = HtmlRenderKitKeyGenerateUtil.getGeneratedKey(family, renderType);
            cd.setComponentName(rendererComponentName);
            annoHandler.appendDI(cd);
            annoHandler.appendAspect(cd);
            annoHandler.appendInitMethod(cd);
            this.customize(cd);
            if (!this.getContainer().hasComponentDef((Object)rendererComponentName)) {
                this.getContainer().register(cd);
            }
        }
    }

    public void setFamilyFieldName(String familyFieldName) {
        this.familyFieldName = familyFieldName;
    }

    public void setRenderTypeFieldName(String renderTypeFieldName) {
        this.renderTypeFieldName = renderTypeFieldName;
    }

    public String getFamilyFieldName() {
        return this.familyFieldName;
    }

    public String getRenderTypeFieldName() {
        return this.renderTypeFieldName;
    }

    protected String getConstantValue(Class clazz, String fieldName) {
        Field f;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        if (beanDesc.hasField(fieldName) && TeedaRendererJarComponentAutoRegister.isPublicFinalConstant(f = beanDesc.getField(fieldName))) {
            return (String)beanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    private static boolean isPublicFinalConstant(Field field) {
        return ModifierUtil.isPublicStaticFinal(field.getModifiers()) && field.getType().equals(String.class);
    }
}

