/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.DecodeUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlInputSecretRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "javax.faces.Secret";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputSecretEnd(context, (HtmlInputSecret)component);
    }

    protected void encodeHtmlInputSecretEnd(FacesContext context, HtmlInputSecret htmlInputSecret) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlInputSecret);
        RendererUtil.renderAttribute(writer, "type", (Object)"password");
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlInputSecret, this.getIdForRender(context, htmlInputSecret));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlInputSecret.getClientId(context));
        String value = ValueHolderUtil.getValueForRender(context, htmlInputSecret);
        if (!htmlInputSecret.isRedisplay()) {
            value = "";
        }
        RendererUtil.renderAttribute(writer, "value", (Object)value);
        this.renderAttributes(htmlInputSecret, writer);
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlInputSecret(context, (HtmlInputSecret)component);
    }

    protected void decodeHtmlInputSecret(FacesContext context, HtmlInputSecret htmlInputSecret) {
        DecodeUtil.decode(context, htmlInputSecret);
    }
}

