/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.render.html.AbstractHtmlMessagesRenderer;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlMessageRenderer
extends AbstractHtmlMessagesRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Message";
    public static final String RENDERER_TYPE = "javax.faces.Message";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlMessageEnd(context, (HtmlMessage)component);
    }

    protected void encodeHtmlMessageEnd(FacesContext context, HtmlMessage htmlMessage) throws IOException {
        String forAttr = htmlMessage.getFor();
        if (forAttr == null) {
            throw new FacesException("for");
        }
        UIComponent forComponent = htmlMessage.findComponent(forAttr);
        if (forComponent == null) {
            throw new FacesException("forComponent");
        }
        String clientId = forComponent.getClientId(context);
        Iterator it = context.getMessages(clientId);
        if (!it.hasNext()) {
            return;
        }
        FacesMessage facesMassage = (FacesMessage)it.next();
        String idForRender = this.getIdForRenderOrNull(context, htmlMessage);
        this.renderOneMessage(context, htmlMessage, facesMassage, idForRender, htmlMessage.getAttributes());
    }

    private String getIdForRenderOrNull(FacesContext context, HtmlMessage htmlMessage) {
        if (RendererUtil.shouldRenderIdAttribute(htmlMessage)) {
            return this.getIdForRender(context, htmlMessage);
        }
        return null;
    }
}

