/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.ArrayList;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;

public class DIContainerUtil {
    private static final Logger logger_ = Logger.getLogger((Class)DIContainerUtil.class);

    private DIContainerUtil() {
    }

    public static Object getComponentNoException(Object componentKey) {
        if (DIContainerUtil.getContainer().hasComponentDef(componentKey)) {
            return DIContainerUtil.getContainer().getComponent(componentKey);
        }
        return null;
    }

    public static Object getComponent(Object componentKey) {
        return DIContainerUtil.getContainer().getComponent(componentKey);
    }

    public static synchronized void register(ComponentDef componentDef) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("componentDef name  = " + componentDef.getComponentName()));
            logger_.debug((Object)("componentDef class = " + componentDef.getComponentClass()));
        }
        DIContainerUtil.getContainer().register(componentDef);
    }

    public static Object[] getComponentKeys(Class clazz) {
        ComponentDef[] componentDefs = DIContainerUtil.getContainer().findComponentDefs((Object)clazz);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < componentDefs.length; ++i) {
            ComponentDef componentDef = componentDefs[i];
            list.add(componentDef.getComponentName());
        }
        return list.toArray();
    }

    public static boolean hasComponent(Object componentKey) {
        return DIContainerUtil.getContainer().hasComponentDef(componentKey);
    }

    private static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}

