/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.portlet.tomahawk.filter;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.webapp.filter.ExtensionsResponseWrapper;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.portlet.tomahawk.headerresource.HeaderResource;
import org.seasar.portlet.tomahawk.headerresource.HeaderResourceFactory;
import org.seasar.portlet.tomahawk.multipart.MultipartPortletRequestWrapper;
import org.seasar.portlet.wrapper.HttpServletRequestWrapper;
import org.seasar.portlet.wrapper.HttpServletResponseWrapper;

public class ExtensionsPortletFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)(class$org$seasar$portlet$tomahawk$filter$ExtensionsPortletFilter == null ? (class$org$seasar$portlet$tomahawk$filter$ExtensionsPortletFilter = ExtensionsPortletFilter.class$("org.seasar.portlet.tomahawk.filter.ExtensionsPortletFilter")) : class$org$seasar$portlet$tomahawk$filter$ExtensionsPortletFilter));
    private static final String UPLOAD_REPOSITORY_PATH = "uploadRepositoryPath";
    private static final String UPLOAD_THRESHOLD_SIZE = "uploadThresholdSize";
    private static final String UPLOAD_MAX_FILE_SIZE = "uploadMaxFileSize";
    private int uploadMaxFileSize = 0x6400000;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;
    private HeaderResource headerResource;
    private PortletConfig portletConfig;
    static /* synthetic */ Class class$org$seasar$portlet$tomahawk$filter$ExtensionsPortletFilter;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing ExtensionsPortletFilter.");
        }
        this.setPortletConfig(filterConfig.getPortletConfig());
        this.headerResource = HeaderResourceFactory.getHeaderResource(this.getPortletConfig().getPortletContext());
        if (this.headerResource == null) {
            log.error((Object)"headerResource is null. This portlet cannot probably put some tags into <head> element.");
        }
        String param = filterConfig.getInitParameter(UPLOAD_MAX_FILE_SIZE);
        this.uploadMaxFileSize = this.resolveSize(param, this.uploadMaxFileSize);
        param = filterConfig.getInitParameter(UPLOAD_THRESHOLD_SIZE);
        this.uploadThresholdSize = this.resolveSize(param, this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter(UPLOAD_REPOSITORY_PATH);
        if (log.isTraceEnabled()) {
            log.trace((Object)("uploadMaxFileSize=" + this.uploadMaxFileSize));
            log.trace((Object)("uploadThresholdSize=" + this.uploadThresholdSize));
            log.trace((Object)("uploadRepositoryPath=" + this.uploadRepositoryPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called renderFilter.");
        }
        if (this.headerResource == null) {
            chain.renderFilter(request, response);
        } else {
            if (request.getAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled") != null) {
                chain.renderFilter(request, response);
                return;
            }
            request.setAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled", (Object)"true");
            HttpServletRequestWrapper extendedRequest = new HttpServletRequestWrapper((PortletRequest)request, this.getPortletConfig().getPortletContext());
            AddResource addResource = null;
            try {
                addResource = AddResourceFactory.getInstance((HttpServletRequest)extendedRequest);
            }
            catch (Throwable th) {
                log.error((Object)"Exception while retrieving addResource", th);
                throw new PortletException(th);
            }
            try {
                addResource.responseStarted();
                if (addResource.requiresBuffer()) {
                    chain.renderFilter(request, response);
                    HttpServletResponseWrapper servletResponse = new HttpServletResponseWrapper(response);
                    ExtensionsResponseWrapper extendedResponse = new ExtensionsResponseWrapper((HttpServletResponse)servletResponse);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter 0 " + extendedResponse.getContentType()));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter 1 " + extendedResponse.toString()));
                    }
                    addResource.parseResponse((HttpServletRequest)extendedRequest, "<html><head></head><body></body></html>", (HttpServletResponse)servletResponse);
                    addResource.writeMyFacesJavascriptBeforeBodyEnd((HttpServletRequest)extendedRequest, (HttpServletResponse)servletResponse);
                    addResource.writeWithFullHeader((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    addResource.writeResponse((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    extendedResponse.finishResponse();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter 12 " + extendedResponse.toString()));
                    }
                    this.headerResource.addHeaderResources((PortletRequest)request, (PortletResponse)response, extendedResponse.toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"renderFilter 3 ");
                    }
                    chain.renderFilter(request, response);
                }
            }
            finally {
                addResource.responseFinished();
            }
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called processActionFilter.");
        }
        if (PortletFileUpload.isMultipartContent((ActionRequest)request)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"ActionRequest is multipart content.");
            }
            request = new MultipartPortletRequestWrapper(request, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath);
        }
        chain.processActionFilter(request, response);
    }

    public void destroy() {
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public boolean isValidContentType(String contentType) {
        return contentType.startsWith("text/html") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/xml");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

