/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.model;

import java.util.Calendar;
import java.util.Date;

import jp.sf.pal.notepad.AbstractTestCase;
import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.dao.NoteDao;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class NotepadTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(NotepadTest.class);

    public static long testId = -1;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public NotepadTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new NotepadTest("addNote"));
        suite.addTest(new NotepadTest("deleteNote"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void addNote()
    {

        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/notepad/Notepad.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        NoteDao noteDao = (NoteDao) container.getComponent(NoteDao.class);

        Note note = new Note();
        Date now = Calendar.getInstance().getTime();
        note.setCreatedtime(now);
        note.setContent("Content");
        note.setName("name");
        note.setOwner("owner");
        note.setPermission(NotepadConstants.PRIVATE_PERMISSION);
        note.setScope("scope");
        note.setUpdatedtime(now);

        noteDao.save(note);

        testId = note.getId();

        SingletonS2ContainerFactory.destroy();

        assertTrue(testId != -1);

    }

    public void deleteNote()
    {
        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/notepad/Notepad.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        NoteDao noteDao = (NoteDao) container.getComponent(NoteDao.class);
        S2SessionFactoryImpl s2SessionFactory = (S2SessionFactoryImpl) SingletonS2ContainerFactory.getContainer()
                .getComponent(S2SessionFactoryImpl.class);

        Note note = noteDao.getNoteById(testId);

        noteDao.delete(note);

        s2SessionFactory.getSession().flush();

        assertNull(noteDao.getNoteById(testId));

        SingletonS2ContainerFactory.destroy();

    }
}
