package jp.sf.pal.tomahawk.wrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Locale;

import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;

// TODO Cannot wrap RenderResponse in Pluto and Jetspeed2
public class ExtensionsRenderResponseWrapper implements RenderResponse
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(ExtensionsRenderResponseWrapper.class);

    private RenderResponse renderResponse;

    private ByteArrayOutputStream stream = null;

    private ExtendedBufferedOutputStream bufferedStream = null;

    private PrintWriter printWriter = null;

    public ExtensionsRenderResponseWrapper(RenderResponse renderResponse)
    {
        this.renderResponse = renderResponse;
        stream = new ByteArrayOutputStream();
    }

    /**
     * @return
     * @throws IOException
     * @see javax.portlet.RenderResponse#getPortletOutputStream()
     */
    public OutputStream getPortletOutputStream() throws IOException
    {
        if (bufferedStream != null)
        {
            return bufferedStream;
        }
        return stream;
    }

    /**
     * @return
     * @throws IOException
     * @see javax.portlet.RenderResponse#getWriter()
     */
    public PrintWriter getWriter() throws IOException
    {
        if (printWriter == null)
        {
            OutputStreamWriter streamWriter = new OutputStreamWriter(
                    getPortletOutputStream(), Charset
                            .forName(getCharacterEncoding()));
            printWriter = new PrintWriter(streamWriter, true);
        }
        return printWriter;
    }

    /**
     * 
     * @see javax.portlet.RenderResponse#reset()
     */
    public void reset()
    {
        renderResponse.reset();
        stream = new ByteArrayOutputStream();
        resetBuffer();
        bufferedStream = null;
    }

    /**
     * 
     * @see javax.portlet.RenderResponse#resetBuffer()
     */
    public void resetBuffer()
    {
        if (isCommitted())
        {
            throw new IllegalStateException(
                    "The response has already been committed.");
        }
        if (bufferedStream != null)
        {
            bufferedStream.reset();
        }
        else
        {
            log.warn("The buffer size is not defined.");
        }
    }

    /**
     * @param arg0
     * @see javax.portlet.RenderResponse#setBufferSize(int)
     */
    public void setBufferSize(int arg0)
    {
        if (isCommitted())
        {
            throw new IllegalStateException(
                    "The response has already been committed.");
        }
        if (bufferedStream == null)
        {
            bufferedStream = new ExtendedBufferedOutputStream(stream, arg0);
        }
        else
        {
            log.warn("The buffer has been already defined.");
        }
    }

    /**
     * @throws IOException
     * @see javax.portlet.RenderResponse#flushBuffer()
     */
    public void flushBuffer() throws IOException
    {
        if (bufferedStream != null)
        {
            bufferedStream.flush();
        }
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#getBufferSize()
     */
    public int getBufferSize()
    {
        if (bufferedStream != null)
        {
            bufferedStream.getBufferSize();
        }

        return 0;
    }

    public class ExtendedBufferedOutputStream extends BufferedOutputStream
    {

        public ExtendedBufferedOutputStream(OutputStream out, int size)
        {
            super(out, size);
        }

        public ExtendedBufferedOutputStream(OutputStream out)
        {
            this(out, 512);
        }

        public void reset()
        {
            count = 0;
        }

        public int getBufferSize()
        {
            return buf.length;
        }
    }

    // Wrapped

    /**
     * @param arg0
     * @param arg1
     * @see javax.portlet.PortletResponse#addProperty(java.lang.String, java.lang.String)
     */
    public void addProperty(String arg0, String arg1)
    {
        renderResponse.addProperty(arg0, arg1);
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#createActionURL()
     */
    public PortletURL createActionURL()
    {
        return renderResponse.createActionURL();
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#createRenderURL()
     */
    public PortletURL createRenderURL()
    {
        return renderResponse.createRenderURL();
    }

    /**
     * @param arg0
     * @return
     * @see javax.portlet.PortletResponse#encodeURL(java.lang.String)
     */
    public String encodeURL(String arg0)
    {
        return renderResponse.encodeURL(arg0);
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#getCharacterEncoding()
     */
    public String getCharacterEncoding()
    {
        return renderResponse.getCharacterEncoding();
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#getContentType()
     */
    public String getContentType()
    {
        return renderResponse.getContentType();
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#getLocale()
     */
    public Locale getLocale()
    {
        return renderResponse.getLocale();
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#getNamespace()
     */
    public String getNamespace()
    {
        return renderResponse.getNamespace();
    }

    /**
     * @param arg0
     * @see javax.portlet.RenderResponse#setContentType(java.lang.String)
     */
    public void setContentType(String arg0)
    {
        renderResponse.setContentType(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.portlet.PortletResponse#setProperty(java.lang.String, java.lang.String)
     */
    public void setProperty(String arg0, String arg1)
    {
        renderResponse.setProperty(arg0, arg1);
    }

    /**
     * @param arg0
     * @see javax.portlet.RenderResponse#setTitle(java.lang.String)
     */
    public void setTitle(String arg0)
    {
        renderResponse.setTitle(arg0);
    }

    /**
     * @return
     * @see javax.portlet.RenderResponse#isCommitted()
     */
    public boolean isCommitted()
    {
        return renderResponse.isCommitted();
    }
}
