package jp.sf.pal.tomahawk.renderkit;

import java.io.OutputStream;
import java.io.Writer;

import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionsRenderKit extends RenderKit
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ExtensionsRenderKit.class);

    public static String WRITER = ExtensionsRenderKit.class.getName()
            + ".WRITER";


    private RenderKit parent;

    public ExtensionsRenderKit(RenderKit parent)
    {
        this.parent = parent;
    }

    /**
     * @param arg0
     * @param arg1
     * @param arg2
     * @see javax.faces.render.RenderKit#addRenderer(java.lang.String, java.lang.String, javax.faces.render.Renderer)
     */
    public void addRenderer(String arg0, String arg1, Renderer arg2)
    {
        parent.addRenderer(arg0, arg1, arg2);
    }

    /**
     * @param arg0
     * @return
     * @see javax.faces.render.RenderKit#createResponseStream(java.io.OutputStream)
     */
    public ResponseStream createResponseStream(OutputStream arg0)
    {
        return parent.createResponseStream(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @param arg2
     * @return
     * @see javax.faces.render.RenderKit#createResponseWriter(java.io.Writer, java.lang.String, java.lang.String)
     */
    public ResponseWriter createResponseWriter(Writer arg0, String arg1,
            String arg2)
    {
        FacesContext context = FacesContext.getCurrentInstance();
        Writer writer = (Writer) context.getExternalContext().getRequestMap()
                .get(WRITER);
        if (writer == null)
        {
            if (log.isDebugEnabled())
            {
                log.debug("createResponseWriter(Writer, String, String) - WRITER is null.");
            }
            return parent.createResponseWriter(arg0, arg1, arg2);
        }

        if (log.isDebugEnabled())
        {
            log.debug("createResponseWriter(Writer, String, String) - ResponseWriter is replaced.");
        }
        return parent.createResponseWriter(arg0, arg1, arg2).cloneWithWriter(
                writer);
    }


    /**
     * @param obj
     * @return
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj)
    {
        return parent.equals(obj);
    }

    /**
     * @param arg0
     * @param arg1
     * @return
     * @see javax.faces.render.RenderKit#getRenderer(java.lang.String, java.lang.String)
     */
    public Renderer getRenderer(String arg0, String arg1)
    {
        return parent.getRenderer(arg0, arg1);
    }

    /**
     * @return
     * @see javax.faces.render.RenderKit#getResponseStateManager()
     */
    public ResponseStateManager getResponseStateManager()
    {
        return parent.getResponseStateManager();
    }

    /**
     * @return
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        return parent.hashCode();
    }

    /**
     * @return
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return parent.toString();
    }
}
