package jp.sf.pal.tomahawk.renderkit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Iterator;

import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class ExtensionsRenderKitFactoryImpl extends RenderKitFactory
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(ExtensionsRenderKitFactoryImpl.class);

    private RenderKitFactory parent;

    public ExtensionsRenderKitFactoryImpl(RenderKitFactory parent)
    {
        if (log.isDebugEnabled())
        {
            log
                    .debug("ExtensionsRenderKitFactoryImpl(RenderKitFactory) parent="
                            + parent);
        }
        this.parent = parent;
    }

    public void addRenderKit(String arg0, RenderKit arg1)
    {
        parent.addRenderKit(arg0, arg1);
    }

    public RenderKit getRenderKit(FacesContext arg0, String arg1)
    {
        return new ExtensionsRenderKit(parent.getRenderKit(arg0, arg1));
    }

    public Iterator getRenderKitIds()
    {
        return parent.getRenderKitIds();
    }

}
