/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.autoregister.AbstractAutoRegister;
import org.seasar.framework.container.autoregister.AutoNaming;
import org.seasar.framework.container.autoregister.ClassPattern;
import org.seasar.framework.container.autoregister.ComponentCustomizer;
import org.seasar.framework.container.autoregister.DefaultAutoNaming;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;

public abstract class AbstractComponentAutoRegister
extends AbstractAutoRegister
implements ClassTraversal.ClassHandler {
    protected static final String CLASS_SUFFIX = ".class";
    private AutoNaming autoNaming = new DefaultAutoNaming();
    public static final String instanceDef_BINDING = "bindingType=may";
    private InstanceDef instanceDef;
    public static final String autoBindingDef_BINDING = "bindingType=may";
    private AutoBindingDef autoBindingDef;
    private boolean externalBinding = false;
    public static final String customizer_BINDING = "bindingType=may";
    private ComponentCustomizer customizer;

    public AutoNaming getAutoNaming() {
        return this.autoNaming;
    }

    public void setAutoNaming(AutoNaming autoNaming) {
        this.autoNaming = autoNaming;
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }

    public ComponentCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(ComponentCustomizer customizer) {
        this.customizer = customizer;
    }

    public void processClass(String packageName, String shortClassName) {
        if (this.isIgnore(packageName, shortClassName)) {
            return;
        }
        for (int i = 0; i < this.getClassPatternSize(); ++i) {
            ClassPattern cp = this.getClassPattern(i);
            if (!cp.isAppliedPackageName(packageName) || !cp.isAppliedShortClassName(shortClassName)) continue;
            this.register(ClassUtil.concatName(packageName, shortClassName));
        }
    }

    protected void register(String className) {
        AnnotationHandler annoHandler = AnnotationHandlerFactory.getAnnotationHandler();
        ComponentDef cd = annoHandler.createComponentDef(className, this.instanceDef, this.autoBindingDef, this.externalBinding);
        if (cd.getComponentName() == null) {
            String[] names = ClassUtil.splitPackageAndShortClassName(className);
            cd.setComponentName(this.autoNaming.defineName(names[0], names[1]));
        }
        annoHandler.appendDI(cd);
        annoHandler.appendAspect(cd);
        annoHandler.appendInitMethod(cd);
        this.customize(cd);
        this.getContainer().register(cd);
    }

    protected void customize(ComponentDef componentDef) {
        if (this.customizer != null) {
            this.customizer.customize(componentDef);
        }
    }
}

