/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.convention.impl;

import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public class NamingConventionImpl
implements NamingConvention {
    private static final char PACKAGE_SEPARATOR = '_';
    private String viewRootPath = "/view";
    private String viewExtension = ".html";
    private String implementationPackageName = "impl";
    private String implementationSuffix = "Impl";
    private String pageSuffix = "Page";
    private String actionSuffix = "Action";
    private String serviceSuffix = "Service";
    private String dxoSuffix = "Dxo";
    private String logicSuffix = "Logic";
    private String daoSuffix = "Dao";
    private String helperSuffix = "Helper";
    private String interceptorSuffix = "Interceptor";
    private String validatorSuffix = "Validator";
    private String dtoSuffix = "Dto";
    private String webPackageName = "web";
    private String dxoPackageName = "dxo";
    private String logicPackageName = "logic";
    private String daoPackageName = "dao";
    private String entityPackageName = "entity";
    private String dtoPackageName = "dto";
    private String servicePackageName = "service";
    private String interceptorPackageName = "interceptor";
    private String validatorPackageName = "validator";
    private String helperPackageName = "helper";

    public String getActionSuffix() {
        return this.actionSuffix;
    }

    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    public String getDaoPackageName() {
        return this.daoPackageName;
    }

    public void setDaoPackage(String daoPackage) {
        this.daoPackageName = daoPackage;
    }

    public String getDaoSuffix() {
        return this.daoSuffix;
    }

    public void setDaoSuffix(String daoSuffix) {
        this.daoSuffix = daoSuffix;
    }

    public String getDtoPackageName() {
        return this.dtoPackageName;
    }

    public void setDtoPackage(String dtoPackage) {
        this.dtoPackageName = dtoPackage;
    }

    public String getDtoSuffix() {
        return this.dtoSuffix;
    }

    public void setDtoSuffix(String dtoSuffix) {
        this.dtoSuffix = dtoSuffix;
    }

    public String getDxoPackageName() {
        return this.dxoPackageName;
    }

    public void setDxoPackage(String dxoPackage) {
        this.dxoPackageName = dxoPackage;
    }

    public String getDxoSuffix() {
        return this.dxoSuffix;
    }

    public void setDxoSuffix(String dxoSuffix) {
        this.dxoSuffix = dxoSuffix;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackage(String entityPackage) {
        this.entityPackageName = entityPackage;
    }

    public String getHelperPackageName() {
        return this.helperPackageName;
    }

    public void setHelperPackageName(String helperPackageName) {
        this.helperPackageName = helperPackageName;
    }

    public String getHelperSuffix() {
        return this.helperSuffix;
    }

    public void setHelperSuffix(String helperSuffix) {
        this.helperSuffix = helperSuffix;
    }

    public String getImplementationPackageName() {
        return this.implementationPackageName;
    }

    public void setImplementationPackageName(String implementationPackageName) {
        this.implementationPackageName = implementationPackageName;
    }

    public String getImplementationSuffix() {
        return this.implementationSuffix;
    }

    public void setImplementationSuffix(String implementationSuffix) {
        this.implementationSuffix = implementationSuffix;
    }

    public String getInterceptorPackageName() {
        return this.interceptorPackageName;
    }

    public void setInterceptorPackage(String interceptorPackage) {
        this.interceptorPackageName = interceptorPackage;
    }

    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    public String getLogicPackageName() {
        return this.logicPackageName;
    }

    public void setLogicPackage(String logicPackage) {
        this.logicPackageName = logicPackage;
    }

    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public void setLogicSuffix(String logicSuffix) {
        this.logicSuffix = logicSuffix;
    }

    public String getPageSuffix() {
        return this.pageSuffix;
    }

    public void setPageSuffix(String pageSuffix) {
        this.pageSuffix = pageSuffix;
    }

    public String getServicePackageName() {
        return this.servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    public String getValidatorPackageName() {
        return this.validatorPackageName;
    }

    public void setValidatorPackage(String validatorPackage) {
        this.validatorPackageName = validatorPackage;
    }

    public String getValidatorSuffix() {
        return this.validatorSuffix;
    }

    public void setValidatorSuffix(String validatorSuffix) {
        this.validatorSuffix = validatorSuffix;
    }

    public String getViewExtension() {
        return this.viewExtension;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension = viewExtension;
    }

    public String getViewRootPath() {
        return this.viewRootPath;
    }

    public void setViewRootPath(String viewRootPath) {
        this.viewRootPath = viewRootPath;
    }

    public String getWebPackageName() {
        return this.webPackageName;
    }

    public void setWebPackageName(String webPackageName) {
        this.webPackageName = webPackageName;
    }

    public String fromClassNameToShortComponentName(String className) {
        if (className == null) {
            throw new EmptyRuntimeException("className");
        }
        String s = StringUtil.decapitalize(ClassUtil.getShortClassName(className));
        if (s.endsWith(this.implementationSuffix)) {
            return s.substring(0, s.length() - this.implementationSuffix.length());
        }
        return s;
    }

    public String fromClassNameToComponentName(String className) {
        if (className == null) {
            throw new EmptyRuntimeException("className");
        }
        String wwwkey = "." + this.webPackageName + ".";
        int index = className.lastIndexOf(wwwkey);
        if (index > 0) {
            String s = className.substring(index + wwwkey.length());
            if (s.endsWith(this.implementationSuffix)) {
                String implkey = "." + this.implementationPackageName + ".";
                index = s.lastIndexOf(implkey);
                if (index < 0) {
                    throw new IllegalArgumentException(className);
                }
                String packageName = s.substring(0, index).replace('.', '_');
                String name = StringUtil.decapitalize(s.substring(index + implkey.length(), s.length() - this.implementationSuffix.length()));
                return packageName + '_' + name;
            }
            index = s.lastIndexOf(46);
            if (index < 0) {
                throw new IllegalArgumentException(className);
            }
            String packageName = s.substring(0, index).replace('.', '_');
            String name = StringUtil.decapitalize(s.substring(index + 1));
            return packageName + '_' + name;
        }
        return this.fromClassNameToShortComponentName(className);
    }

    public String fromPathToPageName(String path) {
        return this.fromPathToComponentName(path, this.pageSuffix);
    }

    protected String fromPathToComponentName(String path, String nameSuffix) {
        if (!path.startsWith(this.viewRootPath) || !path.endsWith(this.viewExtension)) {
            throw new IllegalArgumentException(path);
        }
        String componentName = path.substring(this.viewRootPath.length() + 1, path.length() - this.viewExtension.length()) + nameSuffix;
        return componentName.replace('/', '_');
    }

    public String fromPathToActionName(String path) {
        return this.fromPathToComponentName(path, this.actionSuffix);
    }

    public String fromPageNameToPath(String pageName) {
        if (!pageName.endsWith(this.pageSuffix)) {
            throw new IllegalArgumentException(pageName);
        }
        String name = pageName.substring(0, pageName.length() - this.pageSuffix.length());
        return this.viewRootPath + "/" + name.replace('_', '/') + this.viewExtension;
    }

    public String fromActionNameToPath(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        String name = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        return this.viewRootPath + "/" + name.replace('_', '/') + this.viewExtension;
    }

    public String fromActionNameToPageName(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        return actionName.substring(0, actionName.length() - this.actionSuffix.length()) + this.pageSuffix;
    }
}

