/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.Disposable;

public class DisposableUtil {
    protected static final LinkedList disposables = new LinkedList();

    public static synchronized void add(Disposable disposable) {
        disposables.add(disposable);
    }

    public static synchronized void remove(Disposable disposable) {
        disposables.remove(disposable);
    }

    public static synchronized void dispose() {
        while (!disposables.isEmpty()) {
            Disposable disposable = (Disposable)disposables.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        disposables.clear();
        Logger.dispose();
    }

    public static synchronized void deregisterAllDrivers() {
        try {
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                DriverManager.deregisterDriver(e.nextElement());
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

