/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.StringTokenizer;
import jcifs.util.Log;

public class Config {
    public static void registerSmbURLHandler() {
        String ver = System.getProperty("java.version");
        if (ver.startsWith("1.1.") || ver.startsWith("1.2.")) {
            throw new RuntimeException("jcifs-0.7.0b4+ requires Java 1.3 or above. You are running " + ver);
        }
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        pkgs = pkgs == null ? "jcifs" : pkgs + "|jcifs";
        System.setProperty("java.protocol.handler.pkgs", pkgs);
    }

    public static void load(InputStream in) throws IOException {
        jcifs.util.Config.load(in);
    }

    public static void list(PrintStream out) throws IOException {
        jcifs.util.Config.list(out);
    }

    public static String setProperty(String key, String value) {
        return jcifs.util.Config.setProperty(key, value);
    }

    public static Object get(String key) {
        return jcifs.util.Config.get(key);
    }

    public static String getProperty(String key, String def) {
        return jcifs.util.Config.getProperty(key, def);
    }

    public static String getProperty(String key) {
        return jcifs.util.Config.getProperty(key);
    }

    public static int getInt(String key, int def) {
        return jcifs.util.Config.getInt(key, def);
    }

    public static int getInt(String key) {
        return jcifs.util.Config.getInt(key);
    }

    public static InetAddress getInetAddress(String key, InetAddress def) {
        return jcifs.util.Config.getInetAddress(key, def);
    }

    public static boolean getBoolean(String key, boolean def) {
        return jcifs.util.Config.getBoolean(key, def);
    }

    static {
        FileInputStream in = null;
        try {
            String filename = System.getProperty("jcifs.properties");
            if (filename != null && filename.length() > 1) {
                in = new FileInputStream(filename);
            }
            jcifs.util.Config.load(in);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String mask = jcifs.util.Config.getProperty("jcifs.util.log");
        if (mask != null) {
            StringTokenizer st = new StringTokenizer(mask, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().toUpperCase();
                if (s.startsWith("ALL")) {
                    Log.addMask(-1);
                    continue;
                }
                if (s.startsWith("EXC")) {
                    Log.addMask(0x10000001);
                    continue;
                }
                if (s.startsWith("WAR")) {
                    Log.addMask(2);
                    continue;
                }
                if (s.startsWith("DEB")) {
                    Log.addMask(4);
                    continue;
                }
                if (s.startsWith("HEX")) {
                    Log.addMask(8);
                    continue;
                }
                if (!s.startsWith("NON")) continue;
                Log.setMask(0);
                break;
            }
        }
        jcifs.util.Config.printProperties("properties loaded");
    }
}

