/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcifs.Config;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;

public class NtlmHttpURLConnection
extends HttpURLConnection {
    private static final int MAX_REDIRECTS = Integer.parseInt(System.getProperty("http.maxRedirects", "20"));
    private static final int LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 0);
    private static final String DEFAULT_DOMAIN;
    private HttpURLConnection connection;
    private Map requestProperties;
    private Map headerFields;
    private String authProperty;
    private String method;

    public NtlmHttpURLConnection(HttpURLConnection connection) {
        super(connection.getURL());
        this.connection = connection;
        this.requestProperties = new HashMap();
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.doConnect();
        this.connected = true;
    }

    public URL getURL() {
        return this.connection.getURL();
    }

    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getContentLength();
    }

    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getContentType();
    }

    public String getContentEncoding() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getContentEncoding();
    }

    public long getExpiration() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getExpiration();
    }

    public long getDate() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getDate();
    }

    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getLastModified();
    }

    public String getHeaderField(String header) {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getHeaderField(header);
    }

    private synchronized Map getHeaderFields0() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String key = this.connection.getHeaderFieldKey(0);
        String value = this.connection.getHeaderField(0);
        int i = 1;
        while (key != null || value != null) {
            ArrayList<String> values = (ArrayList<String>)map.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                map.put(key, values);
            }
            values.add(value);
            key = this.connection.getHeaderFieldKey(i);
            value = this.connection.getHeaderField(i);
            ++i;
        }
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        this.headerFields = Collections.unmodifiableMap(map);
        return this.headerFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getHeaderFields() {
        NtlmHttpURLConnection ntlmHttpURLConnection = this;
        synchronized (ntlmHttpURLConnection) {
            if (this.headerFields != null) {
                return this.headerFields;
            }
        }
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.getHeaderFields0();
    }

    public int getHeaderFieldInt(String header, int def) {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getHeaderFieldInt(header, def);
    }

    public long getHeaderFieldDate(String header, long def) {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getHeaderFieldDate(header, def);
    }

    public String getHeaderFieldKey(int index) {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getHeaderFieldKey(index);
    }

    public String getHeaderField(int index) {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getHeaderField(index);
    }

    public Object getContent() throws IOException {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getContent(classes);
    }

    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            this.connect();
        }
        catch (IOException ex) {}
        return this.connection.getOutputStream();
    }

    public String toString() {
        return this.connection.toString();
    }

    public void setDoInput(boolean doInput) {
        this.connection.setDoInput(doInput);
        this.doInput = doInput;
    }

    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    public void setDoOutput(boolean doOutput) {
        this.connection.setDoOutput(doOutput);
        this.doOutput = doOutput;
    }

    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.connection.setAllowUserInteraction(allowUserInteraction);
        this.allowUserInteraction = allowUserInteraction;
    }

    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    public void setUseCaches(boolean useCaches) {
        this.connection.setUseCaches(useCaches);
        this.useCaches = useCaches;
    }

    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.connection.setIfModifiedSince(ifModifiedSince);
        this.ifModifiedSince = ifModifiedSince;
    }

    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.connection.setDefaultUseCaches(defaultUseCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        boolean found = false;
        Map map = this.requestProperties;
        synchronized (map) {
            Iterator entries = this.requestProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
                entry.setValue(value);
                found = true;
                break;
            }
            if (!found) {
                this.requestProperties.put(key, values);
            }
        }
        this.connection.setRequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        List<String> values = null;
        Map map = this.requestProperties;
        synchronized (map) {
            Iterator entries = this.requestProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
                values = (List)entry.getValue();
                values.add(value);
                break;
            }
            if (values == null) {
                values = new ArrayList<String>();
                values.add(value);
                this.requestProperties.put(key, values);
            }
        }
        StringBuffer buffer = new StringBuffer();
        Iterator propertyValues = values.iterator();
        while (propertyValues.hasNext()) {
            buffer.append(propertyValues.next());
            if (!propertyValues.hasNext()) continue;
            buffer.append(", ");
        }
        this.connection.setRequestProperty(key, buffer.toString());
    }

    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRequestProperties() {
        HashMap map = new HashMap();
        Map map2 = this.requestProperties;
        synchronized (map2) {
            Iterator entries = this.requestProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                map.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.connection.setInstanceFollowRedirects(instanceFollowRedirects);
    }

    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    public void setRequestMethod(String requestMethod) throws ProtocolException {
        this.connection.setRequestMethod(requestMethod);
    }

    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    public void disconnect() {
        this.connection.disconnect();
        this.connected = false;
    }

    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    public InputStream getErrorStream() {
        return this.connection.getErrorStream();
    }

    private int parseResponseCode() throws IOException {
        try {
            String response = this.connection.getHeaderField(0);
            int index = response.indexOf(32);
            while (response.charAt(index) == ' ') {
                ++index;
            }
            return Integer.parseInt(response.substring(index, index + 3));
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private synchronized void doConnect() throws IOException {
        this.connection.connect();
        int response = this.parseResponseCode();
        if (response != 401 && response != 407) {
            return;
        }
        Type1Message type1 = (Type1Message)this.attemptNegotiation(response);
        if (type1 == null) {
            return;
        }
        int attempt = 0;
        while (attempt < MAX_REDIRECTS) {
            this.connection.setRequestProperty(this.authProperty, this.method + ' ' + Base64.encode(type1.toByteArray()));
            this.connection.connect();
            response = this.parseResponseCode();
            if (response != 401 && response != 407) {
                return;
            }
            Type3Message type3 = (Type3Message)this.attemptNegotiation(response);
            if (type3 == null) {
                return;
            }
            this.connection.setRequestProperty(this.authProperty, this.method + ' ' + Base64.encode(type3.toByteArray()));
            this.connection.connect();
            response = this.parseResponseCode();
            if (response != 401 && response != 407) {
                return;
            }
            if (++attempt >= MAX_REDIRECTS) continue;
            this.reconnect();
        }
        throw new IOException("Unable to negotiate NTLM authentication.");
    }

    private NtlmMessage attemptNegotiation(int response) throws IOException {
        String authHeader;
        this.authProperty = null;
        this.method = null;
        InputStream errorStream = this.connection.getErrorStream();
        if (errorStream != null && errorStream.available() != 0) {
            int count;
            byte[] buf = new byte[1024];
            while ((count = errorStream.read(buf, 0, 1024)) != -1) {
            }
        }
        if (response == 401) {
            authHeader = "WWW-Authenticate";
            this.authProperty = "Authorization";
        } else {
            authHeader = "Proxy-Authenticate";
            this.authProperty = "Proxy-Authorization";
        }
        String authorization = null;
        List methods = (List)this.getHeaderFields0().get(authHeader);
        if (methods == null) {
            return null;
        }
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            String authMethod = (String)iterator.next();
            if (authMethod.startsWith("NTLM")) {
                if (authMethod.length() == 4) {
                    this.method = "NTLM";
                    break;
                }
                if (authMethod.indexOf(32) != 4) continue;
                this.method = "NTLM";
                authorization = authMethod.substring(5).trim();
                break;
            }
            if (!authMethod.startsWith("Negotiate")) continue;
            if (authMethod.length() == 9) {
                this.method = "Negotiate";
                break;
            }
            if (authMethod.indexOf(32) != 9) continue;
            this.method = "Negotiate";
            authorization = authMethod.substring(10).trim();
            break;
        }
        if (this.method == null) {
            return null;
        }
        NtlmMessage message = authorization != null ? new Type2Message(Base64.decode(authorization)) : null;
        this.reconnect();
        if (message == null) {
            message = new Type1Message();
            if (LM_COMPATIBILITY > 2) {
                message.setFlag(4, true);
            }
        } else {
            String domain = DEFAULT_DOMAIN;
            String user = Type3Message.getDefaultUser();
            String password = Type3Message.getDefaultPassword();
            String userInfo = this.url.getUserInfo();
            if (userInfo != null) {
                int index = (userInfo = URLDecoder.decode(userInfo)).indexOf(58);
                String string = user = index != -1 ? userInfo.substring(0, index) : userInfo;
                if (index != -1) {
                    password = userInfo.substring(index + 1);
                }
                if ((index = user.indexOf(92)) == -1) {
                    index = user.indexOf(47);
                }
                domain = index != -1 ? user.substring(0, index) : domain;
                String string2 = user = index != -1 ? user.substring(index + 1) : user;
            }
            if (user == null) {
                try {
                    PasswordAuthentication auth;
                    URL url = this.getURL();
                    String protocol = url.getProtocol();
                    int port = url.getPort();
                    if (port == -1) {
                        int n = port = "https".equalsIgnoreCase(protocol) ? 443 : 80;
                    }
                    if ((auth = Authenticator.requestPasswordAuthentication(null, port, protocol, "", this.method)) != null) {
                        user = auth.getUserName();
                        password = new String(auth.getPassword());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Type2Message type2 = (Type2Message)message;
            message = new Type3Message(type2, password, domain, user, Type3Message.getDefaultWorkstation());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() throws IOException {
        this.connection = (HttpURLConnection)this.connection.getURL().openConnection();
        this.headerFields = null;
        Map map = this.requestProperties;
        synchronized (map) {
            Iterator properties = this.requestProperties.entrySet().iterator();
            while (properties.hasNext()) {
                Map.Entry property = properties.next();
                String key = (String)property.getKey();
                StringBuffer value = new StringBuffer();
                Iterator values = ((List)property.getValue()).iterator();
                while (values.hasNext()) {
                    value.append(values.next());
                    if (!values.hasNext()) continue;
                    value.append(", ");
                }
                this.connection.setRequestProperty(key, value.toString());
            }
        }
        this.connection.setAllowUserInteraction(this.allowUserInteraction);
        this.connection.setDoInput(this.doInput);
        this.connection.setDoOutput(this.doOutput);
        this.connection.setIfModifiedSince(this.ifModifiedSince);
        this.connection.setUseCaches(this.useCaches);
    }

    static {
        String domain = System.getProperty("http.auth.ntlm.domain");
        if (domain == null) {
            domain = Type3Message.getDefaultDomain();
        }
        DEFAULT_DOMAIN = domain;
    }
}

