/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.Base64;

public class NtlmSsp
implements NtlmFlags {
    public NtlmPasswordAuthentication doAuthentication(HttpServletRequest req, HttpServletResponse resp, byte[] challenge) throws IOException, ServletException {
        return NtlmSsp.authenticate(req, resp, challenge);
    }

    public static NtlmPasswordAuthentication authenticate(HttpServletRequest req, HttpServletResponse resp, byte[] challenge) throws IOException, ServletException {
        String msg = req.getHeader("Authorization");
        if (msg != null && msg.startsWith("NTLM ")) {
            byte[] src = Base64.decode(msg.substring(5));
            if (src[8] == 1) {
                Type1Message type1 = new Type1Message(src);
                Type2Message type2 = new Type2Message(type1, challenge, null);
                msg = Base64.encode(type2.toByteArray());
                resp.setHeader("WWW-Authenticate", "NTLM " + msg);
            } else if (src[8] == 3) {
                byte[] ntResponse;
                Type3Message type3 = new Type3Message(src);
                byte[] lmResponse = type3.getLMResponse();
                if (lmResponse == null) {
                    lmResponse = new byte[]{};
                }
                if ((ntResponse = type3.getNTResponse()) == null) {
                    ntResponse = new byte[]{};
                }
                return new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), lmResponse, ntResponse);
            }
        } else {
            resp.setHeader("WWW-Authenticate", "NTLM");
            resp.setHeader("Connection", "close");
        }
        resp.setStatus(401);
        resp.setContentLength(0);
        resp.flushBuffer();
        return null;
    }
}

